/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.servlet.security.trustedproxy;

import com.linkedin.kafka.cruisecontrol.servlet.security.spnego.SpnegoLoginServiceWithAuthServiceLifecycle;
import com.linkedin.kafka.cruisecontrol.servlet.security.trustedproxy.TrustedProxyAuthorizationService;
import com.linkedin.kafka.cruisecontrol.servlet.security.trustedproxy.TrustedProxyPrincipal;
import java.nio.file.Path;
import java.security.Principal;
import java.util.Collections;
import java.util.List;
import javax.security.auth.Subject;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.security.ConfigurableSpnegoLoginService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SpnegoUserIdentity;
import org.eclipse.jetty.security.SpnegoUserPrincipal;
import org.eclipse.jetty.security.authentication.AuthorizationService;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrustedProxyLoginService
extends ContainerLifeCycle
implements LoginService {
    private static final Logger LOG = LoggerFactory.getLogger(TrustedProxyLoginService.class);
    public static final boolean READ_ONLY_SUBJECT = true;
    private final AuthorizationService _endUserAuthorizer;
    private final ConfigurableSpnegoLoginService _delegateSpnegoLoginService;

    public TrustedProxyLoginService(String realm, AuthorizationService userAuthorizer, List<String> trustedProxies, String trustedProxyIpPattern) {
        this._delegateSpnegoLoginService = new SpnegoLoginServiceWithAuthServiceLifecycle(realm, new TrustedProxyAuthorizationService(trustedProxies, trustedProxyIpPattern));
        this._endUserAuthorizer = userAuthorizer;
    }

    TrustedProxyLoginService(ConfigurableSpnegoLoginService delegateSpnegoLoginService, AuthorizationService userAuthorizer) {
        this._delegateSpnegoLoginService = delegateSpnegoLoginService;
        this._endUserAuthorizer = userAuthorizer;
    }

    public void setServiceName(String serviceName) {
        this._delegateSpnegoLoginService.setServiceName(serviceName);
    }

    public void setHostName(String hostName) {
        this._delegateSpnegoLoginService.setHostName(hostName);
    }

    public void setKeyTabPath(Path path) {
        this._delegateSpnegoLoginService.setKeyTabPath(path);
    }

    public String getName() {
        return this._delegateSpnegoLoginService.getName();
    }

    public UserIdentity login(String username, Object credentials, ServletRequest request) {
        if (!(request instanceof HttpServletRequest)) {
            return null;
        }
        SpnegoUserIdentity serviceIdentity = (SpnegoUserIdentity)this._delegateSpnegoLoginService.login(username, credentials, request);
        SpnegoUserPrincipal servicePrincipal = (SpnegoUserPrincipal)serviceIdentity.getUserPrincipal();
        String doAsUser = request.getParameter("doAs");
        LOG.info("Authorizing proxy user {} from {} service", (Object)doAsUser, (Object)servicePrincipal.getName());
        UserIdentity doAsIdentity = null;
        if (doAsUser != null && !doAsUser.isEmpty()) {
            doAsIdentity = this._endUserAuthorizer.getUserIdentity((HttpServletRequest)request, doAsUser);
        }
        TrustedProxyPrincipal principal = new TrustedProxyPrincipal(doAsUser, servicePrincipal);
        Subject subject = new Subject(true, Collections.singleton(principal), Collections.emptySet(), Collections.emptySet());
        if (!serviceIdentity.isEstablished()) {
            LOG.info("Service user {} isn't authorized as a trusted proxy", (Object)servicePrincipal.getName());
            return new SpnegoUserIdentity(subject, (Principal)((Object)principal), null);
        }
        if (doAsIdentity == null) {
            LOG.info("Couldn't authorize user {}", (Object)doAsUser);
        }
        return new SpnegoUserIdentity(subject, (Principal)((Object)principal), doAsIdentity);
    }

    public boolean validate(UserIdentity user) {
        return this._delegateSpnegoLoginService.validate(user);
    }

    public IdentityService getIdentityService() {
        return this._delegateSpnegoLoginService.getIdentityService();
    }

    public void setIdentityService(IdentityService service) {
        this._delegateSpnegoLoginService.setIdentityService(service);
    }

    public void logout(UserIdentity user) {
        this._delegateSpnegoLoginService.logout(user);
    }

    protected void doStart() throws Exception {
        if (this._endUserAuthorizer instanceof LifeCycle) {
            ((LifeCycle)this._endUserAuthorizer).start();
        }
        this._delegateSpnegoLoginService.start();
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        this._delegateSpnegoLoginService.stop();
        if (this._endUserAuthorizer instanceof LifeCycle) {
            ((LifeCycle)this._endUserAuthorizer).stop();
        }
    }
}

