/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.servlet.security.trustedproxy;

import com.linkedin.kafka.cruisecontrol.servlet.security.SecurityUtils;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.security.UserStore;
import org.eclipse.jetty.security.authentication.AuthorizationService;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.component.AbstractLifeCycle;

public class TrustedProxyAuthorizationService
extends AbstractLifeCycle
implements AuthorizationService {
    private final UserStore _adminUserStore = new UserStore();
    private final Pattern _trustedProxyIpPattern;

    TrustedProxyAuthorizationService(List<String> userNames, String trustedProxyIpPattern) {
        userNames.forEach(u -> this._adminUserStore.addUser(u, SecurityUtils.NO_CREDENTIAL, new String[]{"ADMIN"}));
        this._trustedProxyIpPattern = trustedProxyIpPattern != null ? Pattern.compile(trustedProxyIpPattern) : null;
    }

    public UserIdentity getUserIdentity(HttpServletRequest request, String name) {
        int nameHostSeparatorIndex = name.indexOf(47);
        String serviceName = nameHostSeparatorIndex > 0 ? name.substring(0, nameHostSeparatorIndex) : name;
        UserIdentity serviceIdentity = this._adminUserStore.getUserIdentity(serviceName);
        if (this._trustedProxyIpPattern != null) {
            return this._trustedProxyIpPattern.matcher(request.getRemoteAddr()).matches() ? serviceIdentity : null;
        }
        return serviceIdentity;
    }

    protected void doStart() throws Exception {
        this._adminUserStore.start();
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        this._adminUserStore.stop();
    }
}

