/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.servlet.security.spnego;

import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.servlet.security.DefaultRoleSecurityProvider;
import com.linkedin.kafka.cruisecontrol.servlet.security.spnego.SpnegoLoginServiceWithAuthServiceLifecycle;
import com.linkedin.kafka.cruisecontrol.servlet.security.spnego.SpnegoUserStoreAuthorizationService;
import java.nio.file.Paths;
import org.apache.kafka.common.security.kerberos.KerberosName;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.authentication.AuthorizationService;
import org.eclipse.jetty.security.authentication.ConfigurableSpnegoAuthenticator;

public class SpnegoSecurityProvider
extends DefaultRoleSecurityProvider {
    protected String _privilegesFilePath;
    protected String _keyTabPath;
    protected KerberosName _spnegoPrincipal;

    @Override
    public void init(KafkaCruiseControlConfig config) {
        super.init(config);
        this._privilegesFilePath = config.getString("webserver.auth.credentials.file");
        this._keyTabPath = config.getString("spnego.keytab.file");
        this._spnegoPrincipal = KerberosName.parse((String)config.getString("spnego.principal"));
    }

    @Override
    public LoginService loginService() {
        SpnegoLoginServiceWithAuthServiceLifecycle loginService = new SpnegoLoginServiceWithAuthServiceLifecycle(this._spnegoPrincipal.realm(), this.authorizationService());
        loginService.setServiceName(this._spnegoPrincipal.serviceName());
        loginService.setHostName(this._spnegoPrincipal.hostName());
        loginService.setKeyTabPath(Paths.get(this._keyTabPath, new String[0]));
        return loginService;
    }

    @Override
    public Authenticator authenticator() {
        return new ConfigurableSpnegoAuthenticator();
    }

    public AuthorizationService authorizationService() {
        return new SpnegoUserStoreAuthorizationService(this._privilegesFilePath);
    }
}

