/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.servlet.security.jwt;

import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.servlet.security.DefaultRoleSecurityProvider;
import com.linkedin.kafka.cruisecontrol.servlet.security.UserStoreAuthorizationService;
import com.linkedin.kafka.cruisecontrol.servlet.security.jwt.JwtAuthenticator;
import com.linkedin.kafka.cruisecontrol.servlet.security.jwt.JwtLoginService;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.List;
import javax.servlet.ServletException;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.authentication.AuthorizationService;

public class JwtSecurityProvider
extends DefaultRoleSecurityProvider {
    private String _authenticationProviderUrl;
    private String _cookieName;
    private String _publicKeyLocation;
    private String _privilegesFilePath;
    private List<String> _audiences;

    @Override
    public void init(KafkaCruiseControlConfig config) {
        super.init(config);
        this._authenticationProviderUrl = config.getString("jwt.authentication.provider.url");
        this._cookieName = config.getString("jwt.cookie.name");
        this._publicKeyLocation = config.getString("jwt.auth.certificate.location");
        this._audiences = config.getList("jwt.expected.audiences");
        this._privilegesFilePath = config.getString("webserver.auth.credentials.file");
    }

    @Override
    public LoginService loginService() throws ServletException {
        try {
            return new JwtLoginService(this.authorizationService(), this._publicKeyLocation, this._audiences);
        }
        catch (IOException | CertificateException e) {
            throw new ServletException((Throwable)e);
        }
    }

    @Override
    public Authenticator authenticator() {
        return new JwtAuthenticator(this._authenticationProviderUrl, this._cookieName);
    }

    public AuthorizationService authorizationService() {
        return new UserStoreAuthorizationService(this._privilegesFilePath);
    }
}

