/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.servlet.security.jwt;

import com.linkedin.kafka.cruisecontrol.servlet.security.jwt.JwtAuthenticator;
import com.linkedin.kafka.cruisecontrol.servlet.security.jwt.JwtUserIdentity;
import com.linkedin.kafka.cruisecontrol.servlet.security.jwt.JwtUserPrincipal;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import java.time.Clock;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.security.DefaultIdentityService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.authentication.AuthorizationService;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;

public class JwtLoginService
extends AbstractLifeCycle
implements LoginService {
    public static final String X_509_CERT_TYPE = "X.509";
    private final AuthorizationService _authorizationService;
    private IdentityService _identityService;
    private final RSAPublicKey _publicKey;
    private final List<String> _audiences;
    private Clock _clock;

    public JwtLoginService(AuthorizationService authorizationService, String publicKeyLocation, List<String> audiences) throws IOException, CertificateException {
        this(authorizationService, JwtLoginService.readPublicKey(publicKeyLocation), audiences);
    }

    public JwtLoginService(AuthorizationService authorizationService, RSAPublicKey publicKey, List<String> audiences) {
        this(authorizationService, publicKey, audiences, Clock.systemUTC());
    }

    public JwtLoginService(AuthorizationService authorizationService, RSAPublicKey publicKey, List<String> audiences, Clock clock) {
        this._authorizationService = authorizationService;
        this._identityService = new DefaultIdentityService();
        this._publicKey = publicKey;
        this._audiences = audiences;
        this._clock = clock;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this._authorizationService instanceof LifeCycle) {
            ((LifeCycle)this._authorizationService).start();
        }
    }

    protected void doStop() throws Exception {
        if (this._authorizationService instanceof LifeCycle) {
            ((LifeCycle)this._authorizationService).stop();
        }
        super.doStop();
    }

    public String getName() {
        return null;
    }

    public UserIdentity login(String username, Object credentials, ServletRequest request) {
        boolean valid;
        JWTClaimsSet claimsSet;
        if (!(credentials instanceof SignedJWT)) {
            return null;
        }
        if (!(request instanceof HttpServletRequest)) {
            return null;
        }
        SignedJWT jwtToken = (SignedJWT)credentials;
        try {
            claimsSet = jwtToken.getJWTClaimsSet();
            valid = this.validateToken(jwtToken, claimsSet, username);
        }
        catch (ParseException e) {
            JwtAuthenticator.JWT_LOGGER.warn(String.format("%s: Couldn't parse a JWT token", username), (Throwable)e);
            return null;
        }
        if (valid) {
            String serializedToken = (String)request.getAttribute("com.linkedin.kafka.cruisecontrol.JwtTokenAttribute");
            UserIdentity rolesDelegate = this._authorizationService.getUserIdentity((HttpServletRequest)request, username);
            if (rolesDelegate == null) {
                return null;
            }
            return JwtLoginService.getUserIdentity(jwtToken, claimsSet, serializedToken, username, rolesDelegate);
        }
        return null;
    }

    public boolean validate(UserIdentity user) {
        Set<JWTClaimsSet> claims = user.getSubject().getPrivateCredentials(JWTClaimsSet.class);
        return !claims.isEmpty() && claims.stream().allMatch(this::validateExpiration);
    }

    public IdentityService getIdentityService() {
        return this._identityService;
    }

    public void setIdentityService(IdentityService service) {
        this._identityService = service;
    }

    public void logout(UserIdentity user) {
    }

    void setClock(Clock newClock) {
        this._clock = newClock;
    }

    private boolean validateToken(SignedJWT jwtToken, JWTClaimsSet claimsSet, String username) {
        boolean expValid;
        boolean audValid;
        boolean sigValid = this.validateSignature(jwtToken);
        if (!sigValid) {
            JwtAuthenticator.JWT_LOGGER.warn(String.format("%s: Signature could not be verified", username));
        }
        if (!(audValid = this.validateAudiences(claimsSet))) {
            JwtAuthenticator.JWT_LOGGER.warn(String.format("%s: Audience validation failed", username));
        }
        if (!(expValid = this.validateExpiration(claimsSet))) {
            JwtAuthenticator.JWT_LOGGER.warn(String.format("%s: Expiration validation failed", username));
        }
        return sigValid && audValid && expValid;
    }

    private boolean validateSignature(SignedJWT jwtToken) {
        if (JWSObject.State.SIGNED != jwtToken.getState() || jwtToken.getSignature() == null) {
            return false;
        }
        RSASSAVerifier verifier = new RSASSAVerifier(this._publicKey);
        try {
            return jwtToken.verify((JWSVerifier)verifier);
        }
        catch (JOSEException e) {
            JwtAuthenticator.JWT_LOGGER.warn("Couldn't verify the signature of a token", (Throwable)e);
            return false;
        }
    }

    private boolean validateAudiences(JWTClaimsSet claimsSet) {
        if (this._audiences == null) {
            return true;
        }
        List tokenAudienceList = claimsSet.getAudience();
        for (String aud : tokenAudienceList) {
            if (!this._audiences.contains(aud)) continue;
            JwtAuthenticator.JWT_LOGGER.trace("JWT token audience has been successfully validated");
            return true;
        }
        JwtAuthenticator.JWT_LOGGER.trace("Couldn't find a valid audience");
        return false;
    }

    private boolean validateExpiration(JWTClaimsSet claimsSet) {
        Date expires = claimsSet.getExpirationTime();
        return expires == null || this._clock.instant().isBefore(expires.toInstant());
    }

    private static RSAPublicKey readPublicKey(String location) throws CertificateException, IOException {
        byte[] publicKeyBytes = Files.readAllBytes(Paths.get(location, new String[0]));
        CertificateFactory fact = CertificateFactory.getInstance(X_509_CERT_TYPE);
        X509Certificate cer = (X509Certificate)fact.generateCertificate(new ByteArrayInputStream(publicKeyBytes));
        return (RSAPublicKey)cer.getPublicKey();
    }

    private static UserIdentity getUserIdentity(SignedJWT jwtToken, JWTClaimsSet claimsSet, String serializedToken, String username, UserIdentity rolesDelegate) {
        JwtUserPrincipal principal = new JwtUserPrincipal(username, serializedToken);
        HashSet<Object> privCreds = new HashSet<Object>();
        privCreds.add(jwtToken);
        privCreds.add(claimsSet);
        Subject subject = new Subject(true, Collections.singleton(principal), Collections.emptySet(), privCreds);
        return new JwtUserIdentity(subject, principal, rolesDelegate);
    }
}

