/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.servlet.security.jwt;

import com.nimbusds.jwt.SignedJWT;
import java.io.IOException;
import java.text.ParseException;
import java.util.function.Function;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.UserAuthentication;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.UserIdentity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtAuthenticator
extends LoginAuthenticator {
    public static final String JWT_TOKEN_REQUEST_ATTRIBUTE = "com.linkedin.kafka.cruisecontrol.JwtTokenAttribute";
    static final Logger JWT_LOGGER = LoggerFactory.getLogger((String)"kafka.cruisecontrol.jwt.logger");
    private static final String METHOD = "JWT";
    static final String BEARER = "Bearer";
    static final String REDIRECT_URL = "{redirectUrl}";
    private final String _cookieName;
    private final Function<HttpServletRequest, String> _authenticationProviderUrlGenerator;

    public JwtAuthenticator(String authenticationProviderUrl, String cookieName) {
        this._cookieName = cookieName;
        Function<String, Function> urlGen = url -> req -> url.replace(REDIRECT_URL, req.getRequestURL().toString() + this.getOriginalQueryString((HttpServletRequest)req));
        this._authenticationProviderUrlGenerator = urlGen.apply(authenticationProviderUrl);
    }

    public String getAuthMethod() {
        return METHOD;
    }

    public void prepareRequest(ServletRequest request) {
    }

    public Authentication validateRequest(ServletRequest request, ServletResponse response, boolean mandatory) throws ServerAuthException {
        JWT_LOGGER.trace("Authentication request received for " + request.toString());
        if (!(request instanceof HttpServletRequest) && !(response instanceof HttpServletResponse)) {
            return Authentication.UNAUTHENTICATED;
        }
        HttpServletRequest req = (HttpServletRequest)request;
        if (HttpMethod.OPTIONS.name().toLowerCase().equals(req.getMethod().toLowerCase())) {
            return Authentication.NOT_CHECKED;
        }
        String serializedJWT = this.getJwtFromBearerAuthorization(req);
        if (serializedJWT == null) {
            serializedJWT = this.getJwtFromCookie(req);
        }
        if (serializedJWT == null) {
            String loginURL = this._authenticationProviderUrlGenerator.apply(req);
            JWT_LOGGER.info("No JWT token found, sending redirect to " + loginURL);
            try {
                ((HttpServletResponse)response).sendRedirect(loginURL);
                return Authentication.SEND_CONTINUE;
            }
            catch (IOException e) {
                JWT_LOGGER.error("Couldn't authenticate request", (Throwable)e);
                throw new ServerAuthException((Throwable)e);
            }
        }
        try {
            SignedJWT jwtToken = SignedJWT.parse((String)serializedJWT);
            String userName = jwtToken.getJWTClaimsSet().getSubject();
            request.setAttribute(JWT_TOKEN_REQUEST_ATTRIBUTE, (Object)serializedJWT);
            UserIdentity identity = this.login(userName, jwtToken, request);
            if (identity == null) {
                ((HttpServletResponse)response).setStatus(401);
                return Authentication.SEND_FAILURE;
            }
            return new UserAuthentication(this.getAuthMethod(), identity);
        }
        catch (ParseException pe) {
            String loginURL = this._authenticationProviderUrlGenerator.apply(req);
            JWT_LOGGER.warn("Unable to parse the JWT token, redirecting back to the login page", (Throwable)pe);
            try {
                ((HttpServletResponse)response).sendRedirect(loginURL);
            }
            catch (IOException e) {
                throw new ServerAuthException((Throwable)e);
            }
            return Authentication.SEND_FAILURE;
        }
    }

    public boolean secureResponse(ServletRequest request, ServletResponse response, boolean mandatory, Authentication.User validatedUser) {
        return true;
    }

    String getJwtFromCookie(HttpServletRequest req) {
        String serializedJWT = null;
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (this._cookieName == null || !this._cookieName.equals(cookie.getName())) continue;
                JWT_LOGGER.trace(this._cookieName + " cookie has been found and is being processed");
                serializedJWT = cookie.getValue();
                break;
            }
        }
        return serializedJWT;
    }

    String getJwtFromBearerAuthorization(HttpServletRequest req) {
        String authorizationHeader = req.getHeader(HttpHeader.AUTHORIZATION.asString());
        if (authorizationHeader == null || !authorizationHeader.startsWith(BEARER)) {
            return null;
        }
        return authorizationHeader.substring(BEARER.length()).trim();
    }

    private String getOriginalQueryString(HttpServletRequest request) {
        String originalQueryString = request.getQueryString();
        return originalQueryString == null ? "" : "?" + originalQueryString;
    }
}

