/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.servlet.security;

import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.security.PropertyUserStore;
import org.eclipse.jetty.security.UserStore;
import org.eclipse.jetty.security.authentication.AuthorizationService;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.component.AbstractLifeCycle;

public class UserStoreAuthorizationService
extends AbstractLifeCycle
implements AuthorizationService {
    private final UserStore _userStore;

    public UserStoreAuthorizationService(String privilegesFilePath) {
        this(UserStoreAuthorizationService.userStoreFromFile(privilegesFilePath));
    }

    public UserStoreAuthorizationService(UserStore userStore) {
        this._userStore = userStore;
    }

    public UserIdentity getUserIdentity(HttpServletRequest request, String name) {
        return this._userStore.getUserIdentity(name);
    }

    protected void doStart() throws Exception {
        super.doStart();
        this._userStore.start();
    }

    protected void doStop() throws Exception {
        this._userStore.stop();
        super.doStop();
    }

    private static UserStore userStoreFromFile(String privilegesFilePath) {
        PropertyUserStore userStore = new PropertyUserStore();
        userStore.setConfig(privilegesFilePath);
        return userStore;
    }
}

