/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.servlet.security;

import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.servlet.CruiseControlEndPoint;
import com.linkedin.kafka.cruisecontrol.servlet.security.SecurityProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.util.security.Constraint;

public abstract class DefaultRoleSecurityProvider
implements SecurityProvider {
    public static final String ADMIN = "ADMIN";
    public static final String USER = "USER";
    public static final String VIEWER = "VIEWER";
    private String _webServerApiUrlPrefix;

    @Override
    public void init(KafkaCruiseControlConfig config) {
        this._webServerApiUrlPrefix = config.getString("webserver.api.urlprefix");
    }

    @Override
    public List<ConstraintMapping> constraintMappings() {
        ArrayList<ConstraintMapping> constraintMappings = new ArrayList<ConstraintMapping>();
        CruiseControlEndPoint.getEndpoints().forEach(ep -> {
            if (ep == CruiseControlEndPoint.KAFKA_CLUSTER_STATE || ep == CruiseControlEndPoint.USER_TASKS || ep == CruiseControlEndPoint.REVIEW_BOARD) {
                constraintMappings.add(this.mapping((CruiseControlEndPoint)((Object)ep), VIEWER, USER, ADMIN));
            } else if (ep == CruiseControlEndPoint.BOOTSTRAP || ep == CruiseControlEndPoint.TRAIN) {
                constraintMappings.add(this.mapping((CruiseControlEndPoint)((Object)ep), ADMIN));
            } else {
                constraintMappings.add(this.mapping((CruiseControlEndPoint)((Object)ep), USER, ADMIN));
            }
        });
        CruiseControlEndPoint.postEndpoints().forEach(ep -> constraintMappings.add(this.mapping((CruiseControlEndPoint)((Object)ep), ADMIN)));
        return constraintMappings;
    }

    @Override
    public Set<String> roles() {
        return Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(VIEWER, USER, ADMIN)));
    }

    private ConstraintMapping mapping(CruiseControlEndPoint endpoint, String ... roles) {
        Constraint constraint = new Constraint();
        constraint.setName("BASIC");
        constraint.setRoles(roles);
        constraint.setAuthenticate(true);
        ConstraintMapping mapping = new ConstraintMapping();
        mapping.setPathSpec(this._webServerApiUrlPrefix.replace("*", endpoint.name().toLowerCase()));
        mapping.setConstraint(constraint);
        return mapping;
    }
}

