/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.servlet.security;

import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.servlet.security.DefaultRoleSecurityProvider;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;

public class BasicSecurityProvider
extends DefaultRoleSecurityProvider {
    private String _userCredentialsFile;

    @Override
    public void init(KafkaCruiseControlConfig config) {
        super.init(config);
        this._userCredentialsFile = config.getString("webserver.auth.credentials.file");
    }

    @Override
    public LoginService loginService() {
        return new HashLoginService("DefaultLoginService", this._userCredentialsFile);
    }

    @Override
    public Authenticator authenticator() {
        return new BasicAuthenticator();
    }
}

