/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.servlet.response.stats;

import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.DiskStats;
import com.linkedin.kafka.cruisecontrol.servlet.response.JsonResponseClass;
import com.linkedin.kafka.cruisecontrol.servlet.response.JsonResponseField;
import com.linkedin.kafka.cruisecontrol.servlet.response.stats.BasicStats;
import java.util.HashMap;
import java.util.Map;

@JsonResponseClass
public class SingleBrokerStats
extends BasicStats {
    @JsonResponseField
    protected static final String HOST = "Host";
    @JsonResponseField
    protected static final String BROKER = "Broker";
    @JsonResponseField
    protected static final String RACK = "Rack";
    @JsonResponseField
    protected static final String BROKER_STATE = "BrokerState";
    @JsonResponseField(required=false)
    protected static final String DISK_STATE = "DiskState";
    protected final String _host;
    protected final int _id;
    protected final Broker.State _state;
    protected final boolean _isEstimated;
    protected final Map<String, DiskStats> _diskStatsByLogdir;
    protected final String _rack;

    SingleBrokerStats(Broker broker, double potentialBytesOutRate, boolean isEstimated) {
        super(broker, potentialBytesOutRate);
        this._host = broker.host().name();
        this._id = broker.id();
        this._state = broker.state();
        this._isEstimated = isEstimated;
        this._diskStatsByLogdir = broker.diskStats();
        this._rack = broker.rack().id();
    }

    public String host() {
        return this._host;
    }

    public Broker.State state() {
        return this._state;
    }

    public int id() {
        return this._id;
    }

    public String rack() {
        return this._rack;
    }

    public Map<String, DiskStats> diskStatsByLogdir() {
        return this._diskStatsByLogdir;
    }

    public boolean isEstimated() {
        return this._isEstimated;
    }

    @Override
    public Map<String, Object> getJSONStructure() {
        Map<String, Object> entry = super.getJSONStructure();
        entry.put(HOST, this._host);
        entry.put(BROKER, this._id);
        entry.put(BROKER_STATE, (Object)this._state);
        if (!this._diskStatsByLogdir.isEmpty()) {
            HashMap diskStates = new HashMap(this._diskStatsByLogdir.size());
            this._diskStatsByLogdir.forEach((k, v) -> diskStates.put(k, v.getJSONStructure()));
            entry.put(DISK_STATE, diskStates);
        }
        entry.put(RACK, this._rack);
        return entry;
    }
}

