/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.servlet.response.stats;

import com.google.gson.Gson;
import com.linkedin.cruisecontrol.servlet.parameters.CruiseControlParameters;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.DiskStats;
import com.linkedin.kafka.cruisecontrol.servlet.response.AbstractCruiseControlResponse;
import com.linkedin.kafka.cruisecontrol.servlet.response.JsonResponseClass;
import com.linkedin.kafka.cruisecontrol.servlet.response.JsonResponseField;
import com.linkedin.kafka.cruisecontrol.servlet.response.stats.SingleBrokerStats;
import com.linkedin.kafka.cruisecontrol.servlet.response.stats.SingleHostStats;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentSkipListMap;

@JsonResponseClass
public class BrokerStats
extends AbstractCruiseControlResponse {
    @JsonResponseField
    protected static final String HOSTS = "hosts";
    @JsonResponseField
    protected static final String BROKERS = "brokers";
    protected final List<SingleBrokerStats> _brokerStats = new ArrayList<SingleBrokerStats>();
    protected final SortedMap<String, SingleHostStats> _hostStats = new ConcurrentSkipListMap<String, SingleHostStats>();
    protected int _hostFieldLength = 0;
    protected int _rackFieldLength = 10;
    protected int _logdirFieldLength = 1;
    protected String _cachedPlainTextResponse = null;
    protected String _cachedJSONResponse = null;
    protected boolean _isBrokerStatsEstimated = false;

    public BrokerStats(KafkaCruiseControlConfig config) {
        super(config);
    }

    public void addSingleBrokerStats(Broker broker, double potentialBytesOutRate, boolean isEstimated) {
        String host = broker.host().name();
        String rack = broker.rack().id();
        SingleBrokerStats singleBrokerStats = new SingleBrokerStats(broker, potentialBytesOutRate, isEstimated);
        this._brokerStats.add(singleBrokerStats);
        this._hostFieldLength = Math.max(this._hostFieldLength, host.length());
        this._rackFieldLength = Math.max(this._rackFieldLength, rack.length());
        this._logdirFieldLength = Math.max(this._logdirFieldLength, broker.diskStats().keySet().stream().mapToInt(String::length).max().orElse(-10) + 10);
        this._hostStats.computeIfAbsent(host, h -> new SingleHostStats(host, rack)).addBasicStats(singleBrokerStats);
        this._isBrokerStatsEstimated = this._isBrokerStatsEstimated || isEstimated;
    }

    public boolean isBrokerStatsEstimated() {
        return this._isBrokerStatsEstimated;
    }

    protected String getJSONString() {
        Gson gson = new Gson();
        Map<String, Object> jsonStructure = this.getJsonStructure();
        jsonStructure.put("version", 1);
        return gson.toJson(jsonStructure);
    }

    public Map<String, Object> getJsonStructure() {
        ArrayList<Map<String, Object>> hostStats = new ArrayList<Map<String, Object>>(this._hostStats.size());
        for (Map.Entry<String, SingleHostStats> entry : this._hostStats.entrySet()) {
            hostStats.add(entry.getValue().getJSONStructure());
        }
        ArrayList<Map<String, Object>> brokerStats = new ArrayList<Map<String, Object>>(this._brokerStats.size());
        for (SingleBrokerStats stats : this._brokerStats) {
            Map<String, Object> brokerEntry = stats.getJSONStructure();
            brokerStats.add(brokerEntry);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>(2);
        hashMap.put(HOSTS, hostStats);
        hashMap.put(BROKERS, brokerStats);
        return hashMap;
    }

    @Override
    protected void discardIrrelevantAndCacheRelevant(CruiseControlParameters parameters) {
        this._cachedJSONResponse = this.getJSONString();
        this._cachedPlainTextResponse = this.toString();
        this._brokerStats.clear();
        this._hostStats.clear();
    }

    @Override
    public void discardIrrelevantResponse(CruiseControlParameters parameters) {
        if (this._cachedJSONResponse == null || this._cachedPlainTextResponse == null) {
            this.discardIrrelevantAndCacheRelevant(parameters);
            if (this._cachedJSONResponse == null || this._cachedPlainTextResponse == null) {
                throw new IllegalStateException("Failed to cache the relevant response.");
            }
        }
        this._cachedResponse = parameters.json() ? this._cachedJSONResponse : this._cachedPlainTextResponse;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean hasDiskInfo = !this._brokerStats.get(0).diskStatsByLogdir().isEmpty();
        sb.append(String.format("%n%n%" + this._hostFieldLength + "s%15s%" + this._rackFieldLength + "s%" + this._logdirFieldLength + "s%20s%26s%20s%15s%25s%25s%25s%25s%20s%20s%20s%n", "HOST", "BROKER", "RACK", hasDiskInfo ? "LOGDIR" : "", "DISK_CAP(MB)", "DISK(MB)/_(%)_", "CORE_NUM", "CPU(%)", "NW_IN_CAP(KB/s)", "LEADER_NW_IN(KB/s)", "FOLLOWER_NW_IN(KB/s)", "NW_OUT_CAP(KB/s)", "NW_OUT(KB/s)", "PNW_OUT(KB/s)", "LEADERS/REPLICAS"));
        for (SingleBrokerStats stats : this._brokerStats) {
            sb.append(String.format("%" + this._hostFieldLength + "s,%14d,%" + (this._rackFieldLength - 1) + "s,%" + this._logdirFieldLength + "s%19.3f,%19.3f/%05.2f,%19d,%14.3f,%24.3f,%24.3f,%24.3f,%24.3f,%19.3f,%19.3f,%14d/%d%n", stats.host(), stats.id(), stats.rack(), "", stats.diskCapacity(), stats.diskUtil(), stats.diskUtilPct(), stats.numCore(), stats.cpuUtil(), stats.networkInCapacity(), stats.leaderBytesInRate(), stats.followerBytesInRate(), stats.networkOutCapacity(), stats.bytesOutRate(), stats.potentialBytesOutRate(), stats.numLeaders(), stats.numReplicas()));
            if (!hasDiskInfo) continue;
            Map<String, DiskStats> capacityByDisk = stats.diskStatsByLogdir();
            for (Map.Entry<String, DiskStats> entry : capacityByDisk.entrySet()) {
                DiskStats diskStats = entry.getValue();
                Double util = diskStats.utilization();
                sb.append(String.format("%" + (this._hostFieldLength + 15 + this._rackFieldLength + this._logdirFieldLength) + "s," + (util == null ? "%19s/%5s," : "%19.3f/%05.2f,") + "%119d/%d%n", entry.getKey(), util == null ? "DEAD" : util, util == null ? "DEAD" : diskStats.utilizationPercentage(), diskStats.numLeaderReplicas(), diskStats.numReplicas()));
            }
        }
        return sb.toString();
    }
}

