/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.servlet.response.stats;

import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.servlet.response.JsonResponseClass;
import com.linkedin.kafka.cruisecontrol.servlet.response.JsonResponseField;
import java.util.HashMap;
import java.util.Map;

@JsonResponseClass
public class BasicStats {
    @JsonResponseField
    protected static final String DISK_MB = "DiskMB";
    @JsonResponseField
    protected static final String DISK_PCT = "DiskPct";
    @JsonResponseField
    protected static final String CPU_PCT = "CpuPct";
    @JsonResponseField
    protected static final String LEADER_NW_IN_RATE = "LeaderNwInRate";
    @JsonResponseField
    protected static final String FOLLOWER_NW_IN_RATE = "FollowerNwInRate";
    @JsonResponseField
    protected static final String NW_OUT_RATE = "NwOutRate";
    @JsonResponseField
    protected static final String PNW_OUT_RATE = "PnwOutRate";
    @JsonResponseField
    protected static final String REPLICAS = "Replicas";
    @JsonResponseField
    protected static final String LEADERS = "Leaders";
    @JsonResponseField
    protected static final String DISK_CAPACITY_MB = "DiskCapacityMB";
    @JsonResponseField
    protected static final String NETWORK_IN_CAPACITY = "NetworkInCapacity";
    @JsonResponseField
    protected static final String NETWORK_OUT_CAPACITY = "NetworkOutCapacity";
    @JsonResponseField
    protected static final String NUM_CORE = "NumCore";
    protected double _diskUtil;
    protected double _cpuUtil;
    protected double _leaderBytesInRate;
    protected double _followerBytesInRate;
    protected double _bytesOutRate;
    protected double _potentialBytesOutRate;
    protected int _numReplicas;
    protected int _numLeaders;
    protected double _diskCapacity;
    protected double _networkInCapacity;
    protected double _networkOutCapacity;
    protected int _numCore;

    public BasicStats() {
        this._diskUtil = 0.0;
        this._cpuUtil = 0.0;
        this._leaderBytesInRate = 0.0;
        this._followerBytesInRate = 0.0;
        this._bytesOutRate = 0.0;
        this._potentialBytesOutRate = 0.0;
        this._numReplicas = 0;
        this._numLeaders = 0;
        this._diskCapacity = 0.0;
        this._networkInCapacity = 0.0;
        this._networkOutCapacity = 0.0;
        this._numCore = 0;
    }

    BasicStats(Broker broker, double potentialBytesOutRate) {
        this._diskUtil = Math.max(broker.replicas().isEmpty() ? 0.0 : broker.load().expectedUtilizationFor(Resource.DISK), 0.0);
        this._cpuUtil = Math.max(100.0 * broker.load().expectedUtilizationFor(Resource.CPU) / broker.capacityFor(Resource.CPU), 0.0);
        this._leaderBytesInRate = Math.max(broker.leadershipLoadForNwResources().expectedUtilizationFor(Resource.NW_IN), 0.0);
        this._followerBytesInRate = Math.max(broker.load().expectedUtilizationFor(Resource.NW_IN) - this._leaderBytesInRate, 0.0);
        this._bytesOutRate = Math.max(broker.load().expectedUtilizationFor(Resource.NW_OUT), 0.0);
        this._potentialBytesOutRate = Math.max(potentialBytesOutRate, 0.0);
        this._numReplicas = broker.replicas().size();
        this._numLeaders = broker.leaderReplicas().size();
        this._diskCapacity = Math.max(broker.capacityFor(Resource.DISK), 0.0);
        this._networkInCapacity = Math.max(broker.capacityFor(Resource.NW_IN), 0.0);
        this._networkOutCapacity = Math.max(broker.capacityFor(Resource.NW_OUT), 0.0);
        this._numCore = Math.max((int)broker.capacityFor(Resource.CPU) / 100, 0);
    }

    double diskUtil() {
        return this._diskUtil;
    }

    double diskUtilPct() {
        return this._diskCapacity > 0.0 ? 100.0 * this._diskUtil / this._diskCapacity : -1.0;
    }

    double cpuUtil() {
        return this._cpuUtil;
    }

    double leaderBytesInRate() {
        return this._leaderBytesInRate;
    }

    double followerBytesInRate() {
        return this._followerBytesInRate;
    }

    double bytesOutRate() {
        return this._bytesOutRate;
    }

    double potentialBytesOutRate() {
        return this._potentialBytesOutRate;
    }

    int numReplicas() {
        return this._numReplicas;
    }

    int numLeaders() {
        return this._numLeaders;
    }

    double diskCapacity() {
        return this._diskCapacity;
    }

    double networkInCapacity() {
        return this._networkInCapacity;
    }

    double networkOutCapacity() {
        return this._networkOutCapacity;
    }

    int numCore() {
        return this._numCore;
    }

    void addBasicStats(BasicStats basicStats) {
        this._diskUtil += basicStats.diskUtil();
        this._cpuUtil += basicStats.cpuUtil();
        this._leaderBytesInRate += basicStats.leaderBytesInRate();
        this._followerBytesInRate += basicStats.followerBytesInRate();
        this._bytesOutRate += basicStats.bytesOutRate();
        this._potentialBytesOutRate += basicStats.potentialBytesOutRate();
        this._numReplicas += basicStats.numReplicas();
        this._numLeaders += basicStats.numLeaders();
        this._diskCapacity += basicStats.diskCapacity();
        this._numCore += basicStats.numCore();
        this._networkInCapacity += basicStats.networkInCapacity();
        this._networkOutCapacity += basicStats.networkOutCapacity();
    }

    public Map<String, Object> getJSONStructure() {
        HashMap<String, Object> entry = new HashMap<String, Object>(13);
        entry.put(DISK_MB, this.diskUtil());
        entry.put(DISK_PCT, this.diskUtilPct());
        entry.put(CPU_PCT, this.cpuUtil());
        entry.put(LEADER_NW_IN_RATE, this.leaderBytesInRate());
        entry.put(FOLLOWER_NW_IN_RATE, this.followerBytesInRate());
        entry.put(NW_OUT_RATE, this.bytesOutRate());
        entry.put(PNW_OUT_RATE, this.potentialBytesOutRate());
        entry.put(REPLICAS, this.numReplicas());
        entry.put(LEADERS, this.numLeaders());
        entry.put(DISK_CAPACITY_MB, this.diskCapacity());
        entry.put(NETWORK_IN_CAPACITY, this.networkInCapacity());
        entry.put(NETWORK_OUT_CAPACITY, this.networkOutCapacity());
        entry.put(NUM_CORE, this.numCore());
        return entry;
    }
}

