/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.servlet.response;

import com.google.gson.Gson;
import com.linkedin.cruisecontrol.servlet.parameters.CruiseControlParameters;
import com.linkedin.cruisecontrol.servlet.response.CruiseControlResponse;
import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlUtils;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.servlet.CruiseControlEndPoint;
import com.linkedin.kafka.cruisecontrol.servlet.UserTaskManager;
import com.linkedin.kafka.cruisecontrol.servlet.parameters.UserTasksParameters;
import com.linkedin.kafka.cruisecontrol.servlet.response.AbstractCruiseControlResponse;
import com.linkedin.kafka.cruisecontrol.servlet.response.JsonResponseClass;
import com.linkedin.kafka.cruisecontrol.servlet.response.JsonResponseField;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Predicate;

@JsonResponseClass
public class UserTaskState
extends AbstractCruiseControlResponse {
    @JsonResponseField
    protected static final String USER_TASKS = "userTasks";
    protected final List<UserTaskManager.UserTaskInfo> _userTasks;

    public UserTaskState(List<UserTaskManager.UserTaskInfo> userTasks, KafkaCruiseControlConfig config) {
        super(config);
        this._userTasks = userTasks;
    }

    protected String getJSONString(UserTasksParameters parameters) {
        ArrayList<Map<String, Object>> jsonUserTaskList = new ArrayList<Map<String, Object>>();
        for (UserTaskManager.UserTaskInfo taskInfo : this.prepareResultList(parameters)) {
            jsonUserTaskList.add(taskInfo.getJsonStructure(parameters.fetchCompletedTask() && taskInfo.state() != UserTaskManager.TaskState.ACTIVE));
        }
        HashMap<String, Serializable> jsonResponse = new HashMap<String, Serializable>();
        jsonResponse.put(USER_TASKS, jsonUserTaskList);
        jsonResponse.put("version", Integer.valueOf(1));
        return new Gson().toJson(jsonResponse);
    }

    public List<UserTaskManager.UserTaskInfo> prepareResultList(UserTasksParameters parameters) {
        int entries = parameters.entries();
        ArrayList<UserTaskManager.UserTaskInfo> resultList = entries == Integer.MAX_VALUE ? new ArrayList<UserTaskManager.UserTaskInfo>() : new ArrayList(entries);
        UserTaskState.populateFilteredTasks(resultList, this._userTasks, parameters, entries);
        return resultList.subList(0, Math.min(entries, resultList.size()));
    }

    protected static <T> Predicate<UserTaskManager.UserTaskInfo> checkInputFilter(Set<T> set) {
        if (set == null || set.isEmpty()) {
            return elem -> true;
        }
        return elem -> false;
    }

    protected static void populateFilteredTasks(List<UserTaskManager.UserTaskInfo> filteredTasks, List<UserTaskManager.UserTaskInfo> userTasks, UserTasksParameters parameters, int entries) {
        if (filteredTasks.size() >= entries) {
            return;
        }
        Set<UUID> requestedUserTaskIds = parameters.userTaskIds();
        Set<UserTaskManager.TaskState> requestedTaskStates = parameters.types();
        Set<CruiseControlEndPoint> requestedEndPoints = parameters.endPoints();
        Set<String> requestedClientIds = parameters.clientIds();
        Consumer<UserTaskManager.UserTaskInfo> consumer = elem -> {
            if (filteredTasks.size() < entries) {
                filteredTasks.add((UserTaskManager.UserTaskInfo)elem);
            }
        };
        LinkedList<UserTaskManager.UserTaskInfo> tmpLinkedList = new LinkedList<UserTaskManager.UserTaskInfo>(userTasks);
        tmpLinkedList.stream().filter(UserTaskState.checkInputFilter(requestedUserTaskIds).or(elem -> requestedUserTaskIds.contains(elem.userTaskId()))).filter(UserTaskState.checkInputFilter(requestedTaskStates).or(elem -> requestedTaskStates.contains((Object)elem.state()))).filter(UserTaskState.checkInputFilter(requestedEndPoints).or(elem -> requestedEndPoints.contains(elem.endPoint()))).filter(UserTaskState.checkInputFilter(requestedClientIds).or(elem -> requestedClientIds.contains(elem.clientIdentity()))).forEach(consumer);
    }

    protected String getPlaintext(UserTasksParameters parameters) {
        StringBuilder sb = new StringBuilder();
        int padding = 2;
        int userTaskIdLabelSize = 20;
        int clientAddressLabelSize = 20;
        int startMsLabelSize = 20;
        int statusLabelSize = 10;
        int requestURLLabelSize = 20;
        List<UserTaskManager.UserTaskInfo> taskInfoList = this.prepareResultList(parameters);
        for (UserTaskManager.UserTaskInfo userTaskInfo : taskInfoList) {
            userTaskIdLabelSize = Math.max(userTaskIdLabelSize, userTaskInfo.userTaskId().toString().length());
            clientAddressLabelSize = Math.max(clientAddressLabelSize, userTaskInfo.clientIdentity().length());
            String dateFormatted = KafkaCruiseControlUtils.toDateString(userTaskInfo.startMs(), "YYYY-MM-dd_HH:mm:ss z", "UTC");
            startMsLabelSize = Math.max(startMsLabelSize, dateFormatted.length());
            statusLabelSize = Math.max(statusLabelSize, userTaskInfo.state().toString().length());
            requestURLLabelSize = Math.max(requestURLLabelSize, userTaskInfo.requestWithParams().length());
        }
        StringBuilder formattingStringBuilder = new StringBuilder("%n%-");
        formattingStringBuilder.append(userTaskIdLabelSize + padding).append("s%-").append(clientAddressLabelSize + padding).append("s%-").append(startMsLabelSize + padding).append("s%-").append(statusLabelSize + padding).append("s%-").append(requestURLLabelSize + padding).append("s");
        sb.append(String.format(formattingStringBuilder.toString(), "USER TASK ID", "CLIENT ADDRESS", "START TIME", "STATUS", "REQUEST URL"));
        for (UserTaskManager.UserTaskInfo userTaskInfo : taskInfoList) {
            String dateFormatted = KafkaCruiseControlUtils.toDateString(userTaskInfo.startMs(), "YYYY-MM-dd_HH:mm:ss z", "UTC");
            sb.append(String.format(formattingStringBuilder.toString(), new Object[]{userTaskInfo.userTaskId().toString(), userTaskInfo.clientIdentity(), dateFormatted, userTaskInfo.state(), userTaskInfo.requestWithParams()}));
        }
        if (parameters.fetchCompletedTask()) {
            for (UserTaskManager.UserTaskInfo userTaskInfo : taskInfoList) {
                if (userTaskInfo.state() == UserTaskManager.TaskState.ACTIVE) continue;
                sb.append("\nOriginal response for task ").append(userTaskInfo.userTaskId()).append(":\n").append(UserTaskState.completedTaskResponse(userTaskInfo));
            }
        }
        return sb.toString();
    }

    protected static String completedTaskResponse(UserTaskManager.UserTaskInfo userTaskInfo) {
        try {
            CruiseControlResponse response = userTaskInfo.futures().get(userTaskInfo.futures().size() - 1).get();
            return response.cachedResponse();
        }
        catch (InterruptedException | ExecutionException e) {
            if (userTaskInfo.state().equals((Object)UserTaskManager.TaskState.COMPLETED_WITH_ERROR)) {
                return UserTaskManager.TaskState.COMPLETED_WITH_ERROR.toString();
            }
            throw new IllegalStateException("Error happened in fetching response for task " + userTaskInfo.userTaskId().toString(), e);
        }
    }

    @Override
    protected void discardIrrelevantAndCacheRelevant(CruiseControlParameters parameters) {
        UserTasksParameters userTasksParameters = (UserTasksParameters)parameters;
        this._cachedResponse = userTasksParameters.json() ? this.getJSONString(userTasksParameters) : this.getPlaintext(userTasksParameters);
        this._userTasks.clear();
    }
}

