/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.servlet.response;

import com.google.gson.Gson;
import com.linkedin.cruisecontrol.servlet.parameters.CruiseControlParameters;
import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlUtils;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.servlet.purgatory.RequestInfo;
import com.linkedin.kafka.cruisecontrol.servlet.response.AbstractCruiseControlResponse;
import com.linkedin.kafka.cruisecontrol.servlet.response.JsonResponseClass;
import com.linkedin.kafka.cruisecontrol.servlet.response.JsonResponseField;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

@JsonResponseClass
public class ReviewResult
extends AbstractCruiseControlResponse {
    @JsonResponseField
    protected static final String REQUEST_INFO = "RequestInfo";
    protected final Map<Integer, RequestInfo> _requestInfoById;
    protected final Set<Integer> _filteredRequestIds;

    public ReviewResult(Map<Integer, RequestInfo> requestInfoById, Set<Integer> filteredRequestIds, KafkaCruiseControlConfig config) {
        super(config);
        this._requestInfoById = requestInfoById;
        this._filteredRequestIds = filteredRequestIds.isEmpty() ? this._requestInfoById.keySet() : filteredRequestIds;
    }

    protected String getPlaintext() {
        StringBuilder sb = new StringBuilder();
        int padding = 2;
        int idLabelSize = "Id".length();
        int submitterAddressLabelSize = "SubmitterAddress".length() + 1;
        int submissionTimeLabelSize = "SubmissionTimeMs".length() - 2;
        int statusLabelSize = "Status".length();
        int endpointWithParamsLabelSize = "EndpointWithParams".length() + 2;
        int reasonLabelSize = "Reason".length();
        for (Map.Entry<Integer, RequestInfo> entry : this._requestInfoById.entrySet()) {
            if (!this._filteredRequestIds.contains(entry.getKey())) continue;
            idLabelSize = Math.max(idLabelSize, (int)(Math.log10(entry.getKey().intValue()) + 1.0));
            RequestInfo requestInfo = entry.getValue();
            submitterAddressLabelSize = Math.max(submitterAddressLabelSize, requestInfo.submitterAddress().length());
            String dateFormatted = KafkaCruiseControlUtils.toDateString(requestInfo.submissionTimeMs(), "YYYY-MM-dd_HH:mm:ss z", "UTC");
            submissionTimeLabelSize = Math.max(submissionTimeLabelSize, dateFormatted.length());
            statusLabelSize = Math.max(statusLabelSize, requestInfo.status().toString().length());
            endpointWithParamsLabelSize = Math.max(endpointWithParamsLabelSize, requestInfo.endpointWithParams().length());
            reasonLabelSize = Math.max(reasonLabelSize, requestInfo.reason().length());
        }
        StringBuilder formattingStringBuilder = new StringBuilder("%n%-");
        formattingStringBuilder.append(idLabelSize + padding).append("s%-").append(submitterAddressLabelSize + padding).append("s%-").append(submissionTimeLabelSize + padding).append("s%-").append(statusLabelSize + padding).append("s%-").append(endpointWithParamsLabelSize + padding).append("s%-").append(reasonLabelSize + padding).append("s");
        sb.append(String.format(formattingStringBuilder.toString(), "ID", "SUBMITTER_ADDRESS", "SUBMISSION_TIME", "STATUS", "ENDPOINT_WITH_PARAMS", "REASON"));
        for (Map.Entry<Integer, RequestInfo> entry : this._requestInfoById.entrySet()) {
            if (!this._filteredRequestIds.contains(entry.getKey())) continue;
            RequestInfo requestInfo = entry.getValue();
            String dateFormatted = KafkaCruiseControlUtils.toDateString(requestInfo.submissionTimeMs(), "YYYY-MM-dd_HH:mm:ss z", "UTC");
            sb.append(String.format(formattingStringBuilder.toString(), new Object[]{entry.getKey(), requestInfo.submitterAddress(), dateFormatted, requestInfo.status(), requestInfo.endpointWithParams(), requestInfo.reason()}));
        }
        return sb.toString();
    }

    protected String getJSONString() {
        ArrayList<Map<String, Object>> jsonRequestInfoList = new ArrayList<Map<String, Object>>(this._filteredRequestIds.size());
        for (Map.Entry<Integer, RequestInfo> entry : this._requestInfoById.entrySet()) {
            if (!this._filteredRequestIds.contains(entry.getKey())) continue;
            jsonRequestInfoList.add(entry.getValue().getJsonStructure(entry.getKey()));
        }
        HashMap<String, Serializable> jsonResponse = new HashMap<String, Serializable>(2);
        jsonResponse.put(REQUEST_INFO, jsonRequestInfoList);
        jsonResponse.put("version", Integer.valueOf(1));
        return new Gson().toJson(jsonResponse);
    }

    @Override
    protected void discardIrrelevantAndCacheRelevant(CruiseControlParameters parameters) {
        this._cachedResponse = parameters.json() ? this.getJSONString() : this.getPlaintext();
        this._requestInfoById.clear();
        this._filteredRequestIds.clear();
    }
}

