/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.servlet.response;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.linkedin.kafka.cruisecontrol.KafkaCruiseControl;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.servlet.response.JsonResponseClass;
import com.linkedin.kafka.cruisecontrol.servlet.response.JsonResponseField;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public class ResponseUtils {
    public static final int JSON_VERSION = 1;
    public static final String VERSION = "version";
    @JsonResponseField
    public static final String MESSAGE = "message";

    private ResponseUtils() {
    }

    static void setResponseCode(HttpServletResponse response, int code, boolean json, KafkaCruiseControlConfig config) {
        boolean corsEnabled;
        response.setStatus(code);
        response.setContentType(json ? "application/json" : "text/plain");
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        boolean bl = corsEnabled = config == null ? false : config.getBoolean("webserver.http.cors.enabled");
        if (corsEnabled) {
            response.setHeader("Access-Control-Allow-Origin", config.getString("webserver.http.cors.origin"));
            response.setHeader("Access-Control-Expose-Headers", config.getString("webserver.http.cors.exposeheaders"));
            response.setHeader("Access-Control-Allow-Credentials", "true");
        }
    }

    static String getBaseJSONString(String message) {
        HashMap<String, Object> jsonResponse = new HashMap<String, Object>(2);
        jsonResponse.put(VERSION, 1);
        jsonResponse.put(MESSAGE, message);
        return new Gson().toJson(jsonResponse);
    }

    static void writeResponseToOutputStream(HttpServletResponse response, int responseCode, boolean json, boolean wantJsonSchema, String responseMessage, KafkaCruiseControlConfig config) throws IOException {
        ServletOutputStream out = response.getOutputStream();
        ResponseUtils.setResponseCode(response, responseCode, json, config);
        response.addHeader("Cruise-Control-Version", KafkaCruiseControl.cruiseControlVersion());
        response.addHeader("Cruise-Control-Commit_Id", KafkaCruiseControl.cruiseControlCommitId());
        if (json && wantJsonSchema) {
            response.addHeader("Cruise-Control-JSON-Schema", ResponseUtils.getJsonSchema(responseMessage));
        }
        response.setContentLength(responseMessage.length());
        out.write(responseMessage.getBytes(StandardCharsets.UTF_8));
        out.flush();
    }

    private static String stackTrace(Exception e) {
        if (e == null) {
            return "";
        }
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static void writeErrorResponse(HttpServletResponse response, Exception e, String errorMessage, int responseCode, boolean json, boolean wantJsonSchema, KafkaCruiseControlConfig config) throws IOException {
        String responseMessage;
        ErrorResponse errorResponse = new ErrorResponse(e, errorMessage);
        if (json) {
            Gson gson = new Gson();
            responseMessage = gson.toJson(errorResponse.getJsonStructure());
        } else {
            responseMessage = errorResponse.toString();
        }
        ResponseUtils.writeResponseToOutputStream(response, responseCode, json, wantJsonSchema, responseMessage, config);
    }

    private static String getJsonSchema(String responseMessage) {
        JsonElement response = new JsonParser().parse(responseMessage);
        return ResponseUtils.convertNodeToStringSchemaNode(response, null);
    }

    private static String convertNodeToStringSchemaNode(JsonElement node, String key) {
        StringBuilder result = new StringBuilder();
        if (key != null) {
            result.append("\"" + key + "\": { \"type\": \"");
        } else {
            result.append("{ \"type\": \"");
        }
        if (node.isJsonArray()) {
            result.append("array\"");
            JsonArray arr = node.getAsJsonArray();
            if (arr.size() > 0) {
                result.append(", \"items\": [");
                result.append(ResponseUtils.convertNodeToStringSchemaNode(arr.get(0), null));
                result.append("]");
            }
            result.append("}");
        } else if (node.isJsonPrimitive()) {
            if (node.getAsJsonPrimitive().isBoolean()) {
                result.append("boolean\" }");
            } else if (node.getAsJsonPrimitive().isNumber()) {
                result.append("number\" }");
            } else if (node.getAsJsonPrimitive().isString()) {
                result.append("string\" }");
            }
        } else if (node.isJsonObject()) {
            result.append("object\", \"properties\": ");
            result.append("{");
            Iterator iterator = node.getAsJsonObject().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                key = (String)entry.getKey();
                JsonElement child = (JsonElement)entry.getValue();
                result.append(ResponseUtils.convertNodeToStringSchemaNode(child, key));
                if (!iterator.hasNext()) continue;
                result.append(",");
            }
            result.append("}}");
        } else if (node.isJsonNull()) {
            result.append("}");
        }
        return result.toString();
    }

    @JsonResponseClass
    public static class ErrorResponse {
        @JsonResponseField
        private static final String STACK_TRACE = "stackTrace";
        @JsonResponseField
        private static final String ERROR_MESSAGE = "errorMessage";
        private Exception _exception;
        private String _errorMessage;

        ErrorResponse(Exception exception, String errorMessage) {
            this._errorMessage = errorMessage;
            this._exception = exception;
        }

        public String toString() {
            return this._errorMessage == null ? "" : this._errorMessage;
        }

        public Map<String, Object> getJsonStructure() {
            HashMap<String, Object> exceptionMap = new HashMap<String, Object>();
            exceptionMap.put(ResponseUtils.VERSION, 1);
            exceptionMap.put(STACK_TRACE, ResponseUtils.stackTrace(this._exception));
            exceptionMap.put(ERROR_MESSAGE, this._errorMessage);
            return exceptionMap;
        }
    }
}

