/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.servlet.response;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.linkedin.cruisecontrol.servlet.parameters.CruiseControlParameters;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.servlet.handler.async.runnable.OperationFuture;
import com.linkedin.kafka.cruisecontrol.servlet.response.AbstractCruiseControlResponse;
import com.linkedin.kafka.cruisecontrol.servlet.response.JsonResponseClass;
import com.linkedin.kafka.cruisecontrol.servlet.response.JsonResponseField;
import com.linkedin.kafka.cruisecontrol.servlet.response.ResponseUtils;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;

@JsonResponseClass
public class ProgressResult
extends AbstractCruiseControlResponse {
    @JsonResponseField
    protected static final String PROGRESS = "progress";
    protected List<OperationFuture> _futures;

    public ProgressResult(List<OperationFuture> futures, KafkaCruiseControlConfig config) {
        super(config);
        this._futures = futures;
    }

    protected String getJSONString() {
        HashMap<String, Serializable> jsonResponse = new HashMap<String, Serializable>(2);
        jsonResponse.put("version", Integer.valueOf(1));
        ArrayList<Map<String, Object>> progress = new ArrayList<Map<String, Object>>(this._futures.size());
        for (OperationFuture future : this._futures) {
            progress.add(future.getJsonStructure());
        }
        jsonResponse.put(PROGRESS, progress);
        Gson gson = new GsonBuilder().serializeNulls().serializeSpecialFloatingPointValues().create();
        return gson.toJson(jsonResponse);
    }

    protected String getPlaintext() {
        StringBuilder sb = new StringBuilder();
        for (OperationFuture operationFuture : this._futures) {
            sb.append(String.format("%s:%n%s", operationFuture.operation(), operationFuture.progressString()));
        }
        return sb.toString();
    }

    @Override
    public void writeSuccessResponse(CruiseControlParameters parameters, HttpServletResponse response) throws IOException {
        boolean json = parameters.json();
        boolean wantResponseSchema = parameters.wantResponseSchema();
        this.discardIrrelevantResponse(parameters);
        ResponseUtils.writeResponseToOutputStream(response, 202, json, wantResponseSchema, this._cachedResponse, this._config);
    }

    @Override
    protected void discardIrrelevantAndCacheRelevant(CruiseControlParameters parameters) {
        this._cachedResponse = parameters.json() ? this.getJSONString() : this.getPlaintext();
        this._futures = null;
    }
}

