/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.servlet.response;

import com.linkedin.kafka.cruisecontrol.servlet.response.JsonResponseClass;
import com.linkedin.kafka.cruisecontrol.servlet.response.JsonResponseField;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;

@JsonResponseClass
public class PartitionState {
    @JsonResponseField
    protected static final String TOPIC = "topic";
    @JsonResponseField
    protected static final String PARTITION = "partition";
    @JsonResponseField
    protected static final String LEADER = "leader";
    @JsonResponseField
    protected static final String REPLICAS = "replicas";
    @JsonResponseField
    protected static final String IN_SYNC = "in-sync";
    @JsonResponseField
    protected static final String OUT_OF_SYNC = "out-of-sync";
    @JsonResponseField
    protected static final String OFFLINE = "offline";
    protected final String _topic;
    protected final int _partition;
    protected final int _leader;
    protected final List<Integer> _replicas;
    protected final List<Integer> _inSyncReplicas;
    protected final Set<Integer> _outOfSyncReplicas;
    protected final Set<Integer> _offlineReplicas;

    public PartitionState(PartitionInfo partitionInfo) {
        this._topic = partitionInfo.topic();
        this._partition = partitionInfo.partition();
        this._leader = partitionInfo.leader() == null ? -1 : partitionInfo.leader().id();
        this._replicas = Arrays.stream(partitionInfo.replicas()).map(Node::id).collect(Collectors.toList());
        this._inSyncReplicas = Arrays.stream(partitionInfo.inSyncReplicas()).map(Node::id).collect(Collectors.toList());
        this._outOfSyncReplicas = new HashSet<Integer>(this._replicas);
        this._outOfSyncReplicas.removeAll(this._inSyncReplicas);
        this._offlineReplicas = Arrays.stream(partitionInfo.offlineReplicas()).map(Node::id).collect(Collectors.toSet());
    }

    protected Map<String, Object> getJsonStructure() {
        HashMap<String, Object> recordMap = new HashMap<String, Object>(7);
        recordMap.put(TOPIC, this._topic);
        recordMap.put(PARTITION, this._partition);
        recordMap.put(LEADER, this._leader);
        recordMap.put(REPLICAS, this._replicas);
        recordMap.put(IN_SYNC, this._inSyncReplicas);
        recordMap.put(OUT_OF_SYNC, this._outOfSyncReplicas);
        recordMap.put(OFFLINE, this._offlineReplicas);
        return recordMap;
    }

    protected String writeKafkaPartitionState(int topicNameLength) {
        return String.format("%" + topicNameLength + "s%10s%10s%30s%30s%25s%25s%n", this._topic, this._partition, this._leader, this._replicas, this._inSyncReplicas, this._outOfSyncReplicas, this._offlineReplicas);
    }
}

