/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.servlet.response;

import com.google.gson.Gson;
import com.linkedin.cruisecontrol.servlet.parameters.CruiseControlParameters;
import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.model.Partition;
import com.linkedin.kafka.cruisecontrol.monitor.metricdefinition.KafkaMetricDef;
import com.linkedin.kafka.cruisecontrol.servlet.response.AbstractCruiseControlResponse;
import com.linkedin.kafka.cruisecontrol.servlet.response.JsonResponseClass;
import com.linkedin.kafka.cruisecontrol.servlet.response.JsonResponseExternalFields;
import com.linkedin.kafka.cruisecontrol.servlet.response.JsonResponseField;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

@JsonResponseClass
public class PartitionLoadState
extends AbstractCruiseControlResponse {
    @JsonResponseField
    protected static final String RECORDS = "records";
    protected final List<Partition> _sortedPartitions;
    protected final boolean _wantMaxLoad;
    protected final boolean _wantAvgLoad;
    protected final int _entries;
    protected final int _partitionUpperBoundary;
    protected final int _partitionLowerBoundary;
    protected final int _topicNameLength;
    protected Pattern _topic;

    public PartitionLoadState(List<Partition> sortedPartitions, boolean wantMaxLoad, boolean wantAvgLoad, int entries, int partitionUpperBoundary, int partitionLowerBoundary, Pattern topic, int topicNameLength, KafkaCruiseControlConfig config) {
        super(config);
        this._sortedPartitions = sortedPartitions;
        this._wantMaxLoad = wantMaxLoad;
        this._wantAvgLoad = wantAvgLoad;
        this._entries = entries;
        this._partitionUpperBoundary = partitionUpperBoundary;
        this._partitionLowerBoundary = partitionLowerBoundary;
        this._topic = topic;
        this._topicNameLength = topicNameLength;
    }

    protected String getPlaintext() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%" + this._topicNameLength + "s%10s%30s%20s%20s%20s%20s%20s%n", "PARTITION", "LEADER", "FOLLOWERS", "CPU (%_CORES)", "DISK (MB)", "NW_IN (KB/s)", "NW_OUT (KB/s)", "MSG_IN (#/s)"));
        int numEntries = 0;
        for (Partition p : this._sortedPartitions) {
            if (this.shouldSkipPartition(p)) continue;
            if (++numEntries > this._entries) break;
            List followers = p.followers().stream().map(replica -> replica.broker().id()).collect(Collectors.toList());
            sb.append(String.format("%" + this._topicNameLength + "s%10s%30s%19.6f%19.3f%19.3f%19.3f%19.3f%n", p.leader().topicPartition(), p.leader().broker().id(), followers, p.leader().load().expectedUtilizationFor(Resource.CPU, this._wantMaxLoad, this._wantAvgLoad), p.leader().load().expectedUtilizationFor(Resource.DISK, this._wantMaxLoad, this._wantAvgLoad), p.leader().load().expectedUtilizationFor(Resource.NW_IN, this._wantMaxLoad, this._wantAvgLoad), p.leader().load().expectedUtilizationFor(Resource.NW_OUT, this._wantMaxLoad, this._wantAvgLoad), p.leader().load().expectedUtilizationFor(KafkaMetricDef.MESSAGE_IN_RATE, this._wantMaxLoad, this._wantAvgLoad)));
        }
        return sb.toString();
    }

    private boolean shouldSkipPartition(Partition partition) {
        return this._topic != null && !this._topic.matcher(partition.topicPartition().topic()).matches() || partition.topicPartition().partition() < this._partitionLowerBoundary || partition.topicPartition().partition() > this._partitionUpperBoundary;
    }

    @Override
    protected void discardIrrelevantAndCacheRelevant(CruiseControlParameters parameters) {
        this._cachedResponse = parameters.json() ? this.getJSONString() : this.getPlaintext();
        this._sortedPartitions.clear();
        this._topic = null;
    }

    protected String getJSONString() {
        HashMap<String, Serializable> partitionMap = new HashMap<String, Serializable>();
        ArrayList<Map<String, Object>> partitionList = new ArrayList<Map<String, Object>>();
        partitionMap.put("version", Integer.valueOf(1));
        int numEntries = 0;
        for (Partition p : this._sortedPartitions) {
            if (this.shouldSkipPartition(p)) continue;
            if (++numEntries > this._entries) break;
            partitionList.add(new PartitionLoadRecord(p).getJsonStructure());
        }
        partitionMap.put(RECORDS, partitionList);
        Gson gson = new Gson();
        return gson.toJson(partitionMap);
    }

    @JsonResponseClass
    @JsonResponseExternalFields(value=Resource.class)
    protected class PartitionLoadRecord {
        @JsonResponseField
        protected static final String TOPIC = "topic";
        @JsonResponseField
        protected static final String PARTITION = "partition";
        @JsonResponseField
        protected static final String LEADER = "leader";
        @JsonResponseField
        protected static final String FOLLOWERS = "followers";
        @JsonResponseField
        protected static final String MSG_IN = "msg_in";
        protected Partition _partition;

        PartitionLoadRecord(Partition partition) {
            this._partition = partition;
        }

        protected Map<String, Object> getJsonStructure() {
            List followers = this._partition.followers().stream().map(replica -> replica.broker().id()).collect(Collectors.toList());
            HashMap<String, Object> record = new HashMap<String, Object>(9);
            record.put(TOPIC, this._partition.leader().topicPartition().topic());
            record.put(PARTITION, this._partition.leader().topicPartition().partition());
            record.put(LEADER, this._partition.leader().broker().id());
            record.put(FOLLOWERS, followers);
            record.put(Resource.CPU.resource(), this._partition.leader().load().expectedUtilizationFor(Resource.CPU, PartitionLoadState.this._wantMaxLoad, PartitionLoadState.this._wantAvgLoad));
            record.put(Resource.DISK.resource(), this._partition.leader().load().expectedUtilizationFor(Resource.DISK, PartitionLoadState.this._wantMaxLoad, PartitionLoadState.this._wantAvgLoad));
            record.put(Resource.NW_IN.resource(), this._partition.leader().load().expectedUtilizationFor(Resource.NW_IN, PartitionLoadState.this._wantMaxLoad, PartitionLoadState.this._wantAvgLoad));
            record.put(Resource.NW_OUT.resource(), this._partition.leader().load().expectedUtilizationFor(Resource.NW_OUT, PartitionLoadState.this._wantMaxLoad, PartitionLoadState.this._wantAvgLoad));
            record.put(MSG_IN, this._partition.leader().load().expectedUtilizationFor(KafkaMetricDef.MESSAGE_IN_RATE, PartitionLoadState.this._wantMaxLoad, PartitionLoadState.this._wantAvgLoad));
            return record;
        }
    }
}

