/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.servlet.response;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.linkedin.cruisecontrol.servlet.parameters.CruiseControlParameters;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizerResult;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.executor.ExecutionProposal;
import com.linkedin.kafka.cruisecontrol.model.ClusterModelStats;
import com.linkedin.kafka.cruisecontrol.servlet.CruiseControlEndPoint;
import com.linkedin.kafka.cruisecontrol.servlet.parameters.AddedOrRemovedBrokerParameters;
import com.linkedin.kafka.cruisecontrol.servlet.parameters.DemoteBrokerParameters;
import com.linkedin.kafka.cruisecontrol.servlet.parameters.KafkaOptimizationParameters;
import com.linkedin.kafka.cruisecontrol.servlet.response.AbstractCruiseControlResponse;
import com.linkedin.kafka.cruisecontrol.servlet.response.JsonResponseClass;
import com.linkedin.kafka.cruisecontrol.servlet.response.JsonResponseField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonResponseClass
public class OptimizationResult
extends AbstractCruiseControlResponse {
    private static final Logger LOG = LoggerFactory.getLogger(OptimizationResult.class);
    @JsonResponseField
    protected static final String SUMMARY = "summary";
    @JsonResponseField(required=false)
    protected static final String PROPOSALS = "proposals";
    @JsonResponseField
    protected static final String GOAL_SUMMARY = "goalSummary";
    @JsonResponseField
    protected static final String LOAD_AFTER_OPTIMIZATION = "loadAfterOptimization";
    @JsonResponseField(required=false)
    protected static final String LOAD_BEFORE_OPTIMIZATION = "loadBeforeOptimization";
    protected OptimizerResult _optimizerResult;
    protected String _cachedJSONResponse;
    protected String _cachedPlaintextResponse;

    public OptimizationResult(OptimizerResult optimizerResult, KafkaCruiseControlConfig config) {
        super(config);
        this._optimizerResult = optimizerResult;
        this._cachedJSONResponse = null;
        this._cachedPlaintextResponse = null;
    }

    public OptimizerResult optimizerResult() {
        return this._optimizerResult;
    }

    public String cachedJSONResponse() {
        return this._cachedJSONResponse;
    }

    public String cachedPlaintextResponse() {
        return this._cachedPlaintextResponse;
    }

    protected String getPlaintextPretext(CruiseControlParameters parameters) {
        switch ((CruiseControlEndPoint)parameters.endPoint()) {
            case ADD_BROKER: {
                return String.format("%n%nCluster load after adding broker %s:%n", ((AddedOrRemovedBrokerParameters)parameters).brokerIds());
            }
            case REMOVE_BROKER: {
                return String.format("%n%nCluster load after removing broker %s:%n", ((AddedOrRemovedBrokerParameters)parameters).brokerIds());
            }
            case FIX_OFFLINE_REPLICAS: {
                return String.format("%n%nCluster load after fixing offline replicas:%n", new Object[0]);
            }
            case PROPOSALS: {
                return String.format("%n%nOptimized load:%n", new Object[0]);
            }
            case REBALANCE: {
                return String.format("%n%nCluster load after rebalance:%n", new Object[0]);
            }
            case DEMOTE_BROKER: {
                return String.format("%n%nCluster load after demoting broker %s:%n", ((DemoteBrokerParameters)parameters).brokerIds());
            }
            case TOPIC_CONFIGURATION: {
                return String.format("%n%nCluster load after updating replication factor of topics %s%n", this._optimizerResult.topicsWithReplicationFactorChange());
            }
        }
        LOG.error("Unrecognized endpoint.");
        return "Unrecognized endpoint.";
    }

    protected String getPlaintext(boolean isVerbose, String pretext) {
        StringBuilder sb = new StringBuilder();
        if (isVerbose) {
            sb.append(this._optimizerResult.goalProposals().toString());
        }
        this.writeProposalSummary(sb);
        if (isVerbose) {
            sb.append(String.format("%n%nCurrent load:%n%s", this._optimizerResult.brokerStatsBeforeOptimization().toString()));
        }
        sb.append(String.format("%s%s", pretext, this._optimizerResult.brokerStatsAfterOptimization().toString()));
        return sb.toString();
    }

    @Override
    protected void discardIrrelevantAndCacheRelevant(CruiseControlParameters parameters) {
        boolean isVerbose = ((KafkaOptimizationParameters)parameters).isVerbose();
        String string = this._cachedResponse = parameters.json() ? this.getJSONString(isVerbose) : this.getPlaintext(isVerbose, this.getPlaintextPretext(parameters));
        if (parameters.json()) {
            this._cachedJSONResponse = this._cachedResponse;
        } else {
            this._cachedPlaintextResponse = this._cachedResponse;
        }
        this._optimizerResult = null;
    }

    public void discardIrrelevantAndCacheJsonAndPlaintext() {
        if (this._optimizerResult != null) {
            this._cachedJSONResponse = this.getJSONString(false);
            this._cachedPlaintextResponse = this.getPlaintext(false, String.format("%n%nCluster load after self-healing:%n", new Object[0]));
            this._optimizerResult = null;
        }
    }

    protected String getJSONString(boolean isVerbose) {
        HashMap<String, Object> optimizationResult = new HashMap<String, Object>();
        if (isVerbose) {
            optimizationResult.put(PROPOSALS, this._optimizerResult.goalProposals().stream().map(ExecutionProposal::getJsonStructure).collect(Collectors.toSet()));
            optimizationResult.put(LOAD_BEFORE_OPTIMIZATION, this._optimizerResult.brokerStatsBeforeOptimization().getJsonStructure());
        }
        optimizationResult.put(SUMMARY, this._optimizerResult.getProposalSummaryForJson());
        ArrayList<Map<String, Object>> goalSummary = new ArrayList<Map<String, Object>>();
        for (String goalName : this._optimizerResult.statsByGoalName().keySet()) {
            goalSummary.add(new GoalStatus(goalName).getJsonStructure());
        }
        optimizationResult.put(GOAL_SUMMARY, goalSummary);
        optimizationResult.put(LOAD_AFTER_OPTIMIZATION, this._optimizerResult.brokerStatsAfterOptimization().getJsonStructure());
        optimizationResult.put("version", 1);
        Gson gson = new GsonBuilder().serializeNulls().serializeSpecialFloatingPointValues().create();
        return gson.toJson(optimizationResult);
    }

    protected void writeProposalSummary(StringBuilder sb) {
        sb.append(this._optimizerResult.getProposalSummary());
        for (Map.Entry<String, ClusterModelStats> entry : this._optimizerResult.statsByGoalName().entrySet()) {
            String goalName = entry.getKey();
            sb.append(String.format("%n%nStats for %s(%s):%n", goalName, this._optimizerResult.goalResultDescription(goalName)));
            sb.append(entry.getValue().toString());
        }
    }

    @JsonResponseClass
    protected class GoalStatus {
        @JsonResponseField
        protected static final String GOAL = "goal";
        @JsonResponseField
        protected static final String STATUS = "status";
        @JsonResponseField
        protected static final String CLUSTER_MODEL_STATS = "clusterModelStats";
        protected String _goalName;

        GoalStatus(String goalName) {
            this._goalName = goalName;
        }

        protected Map<String, Object> getJsonStructure() {
            HashMap<String, Object> goalMap = new HashMap<String, Object>(3);
            goalMap.put(GOAL, this._goalName);
            goalMap.put(STATUS, OptimizationResult.this._optimizerResult.goalResultDescription(this._goalName));
            goalMap.put(CLUSTER_MODEL_STATS, OptimizationResult.this._optimizerResult.statsByGoalName().get(this._goalName).getJsonStructure());
            return goalMap;
        }
    }
}

