/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.servlet.response;

import com.google.gson.Gson;
import com.linkedin.cruisecontrol.servlet.parameters.CruiseControlParameters;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.config.TopicConfigProvider;
import com.linkedin.kafka.cruisecontrol.servlet.parameters.KafkaClusterStateParameters;
import com.linkedin.kafka.cruisecontrol.servlet.response.AbstractCruiseControlResponse;
import com.linkedin.kafka.cruisecontrol.servlet.response.ClusterBrokerState;
import com.linkedin.kafka.cruisecontrol.servlet.response.ClusterPartitionState;
import com.linkedin.kafka.cruisecontrol.servlet.response.JsonResponseClass;
import com.linkedin.kafka.cruisecontrol.servlet.response.JsonResponseField;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.common.Cluster;

@JsonResponseClass
public class KafkaClusterState
extends AbstractCruiseControlResponse {
    @JsonResponseField
    public static final String KAFKA_BROKER_STATE = "KafkaBrokerState";
    @JsonResponseField
    public static final String KAFKA_PARTITION_STATE = "KafkaPartitionState";
    protected final Map<String, Properties> _allTopicConfigs;
    protected final Properties _clusterConfigs;
    protected final AdminClient _adminClient;
    protected Cluster _kafkaCluster;

    public KafkaClusterState(Cluster kafkaCluster, TopicConfigProvider topicConfigProvider, AdminClient adminClient, KafkaCruiseControlConfig config) {
        super(config);
        this._kafkaCluster = kafkaCluster;
        this._allTopicConfigs = topicConfigProvider.allTopicConfigs();
        this._clusterConfigs = topicConfigProvider.clusterConfigs();
        this._adminClient = adminClient;
    }

    protected String getJSONString(CruiseControlParameters parameters) {
        Map<String, Object> jsonStructure;
        Gson gson = new Gson();
        KafkaClusterStateParameters kafkaClusterStateParams = (KafkaClusterStateParameters)parameters;
        boolean isVerbose = kafkaClusterStateParams.isVerbose();
        Pattern topic = kafkaClusterStateParams.topic();
        try {
            jsonStructure = this.getJsonStructure(isVerbose, topic);
            jsonStructure.put("version", 1);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Failed to populate broker logDir state.", e);
        }
        return gson.toJson(jsonStructure);
    }

    protected Map<String, Object> getJsonStructure(boolean verbose, Pattern topic) throws ExecutionException, InterruptedException {
        HashMap<String, Object> cruiseControlState = new HashMap<String, Object>();
        cruiseControlState.put(KAFKA_BROKER_STATE, new ClusterBrokerState(this._kafkaCluster, this._adminClient, this._config).getJsonStructure());
        cruiseControlState.put(KAFKA_PARTITION_STATE, new ClusterPartitionState(verbose, topic, this._kafkaCluster, this._allTopicConfigs, this._clusterConfigs).getJsonStructure());
        return cruiseControlState;
    }

    protected String getPlaintext(CruiseControlParameters parameters) {
        KafkaClusterStateParameters kafkaClusterStateParams = (KafkaClusterStateParameters)parameters;
        boolean isVerbose = kafkaClusterStateParams.isVerbose();
        Pattern topic = kafkaClusterStateParams.topic();
        StringBuilder sb = new StringBuilder();
        try {
            new ClusterBrokerState(this._kafkaCluster, this._adminClient, this._config).writeBrokerSummary(sb);
            new ClusterPartitionState(isVerbose, topic, this._kafkaCluster, this._allTopicConfigs, this._clusterConfigs).writePartitionSummary(sb, isVerbose);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Failed to populate broker logDir state.", e);
        }
        return sb.toString();
    }

    @Override
    protected void discardIrrelevantAndCacheRelevant(CruiseControlParameters parameters) {
        this._cachedResponse = parameters.json() ? this.getJSONString(parameters) : this.getPlaintext(parameters);
        this._kafkaCluster = null;
    }
}

