/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.servlet.response;

import com.google.gson.Gson;
import com.linkedin.cruisecontrol.servlet.parameters.CruiseControlParameters;
import com.linkedin.kafka.cruisecontrol.analyzer.AnalyzerState;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.Goal;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.detector.AnomalyDetectorState;
import com.linkedin.kafka.cruisecontrol.executor.ExecutionTask;
import com.linkedin.kafka.cruisecontrol.executor.ExecutionTaskState;
import com.linkedin.kafka.cruisecontrol.executor.ExecutorState;
import com.linkedin.kafka.cruisecontrol.model.LinearRegressionModelParameters;
import com.linkedin.kafka.cruisecontrol.monitor.LoadMonitorState;
import com.linkedin.kafka.cruisecontrol.servlet.parameters.CruiseControlStateParameters;
import com.linkedin.kafka.cruisecontrol.servlet.response.AbstractCruiseControlResponse;
import com.linkedin.kafka.cruisecontrol.servlet.response.JsonResponseClass;
import com.linkedin.kafka.cruisecontrol.servlet.response.JsonResponseField;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import org.apache.commons.math3.linear.SingularMatrixException;

@JsonResponseClass
public class CruiseControlState
extends AbstractCruiseControlResponse {
    protected static final String INTER_BROKER_PARTITION_MOVEMENTS = "inter-broker partition movements";
    protected static final String INTRA_BROKER_PARTITION_MOVEMENTS = "intra-broker partition movements";
    protected static final String LEADERSHIP_MOVEMENTS = "leadership movements";
    @JsonResponseField(required=false)
    protected static final String MONITOR_STATE = "MonitorState";
    @JsonResponseField(required=false)
    protected static final String EXECUTOR_STATE = "ExecutorState";
    @JsonResponseField(required=false)
    protected static final String ANALYZER_STATE = "AnalyzerState";
    @JsonResponseField(required=false)
    protected static final String ANOMALY_DETECTOR_STATE = "AnomalyDetectorState";
    protected ExecutorState _executorState;
    protected LoadMonitorState _monitorState;
    protected AnalyzerState _analyzerState;
    protected AnomalyDetectorState _anomalyDetectorState;

    public CruiseControlState(ExecutorState executionState, LoadMonitorState monitorState, AnalyzerState analyzerState, AnomalyDetectorState anomalyDetectorState, KafkaCruiseControlConfig config) {
        super(config);
        this._executorState = executionState;
        this._monitorState = monitorState;
        this._analyzerState = analyzerState;
        this._anomalyDetectorState = anomalyDetectorState;
    }

    public ExecutorState executorState() {
        return this._executorState;
    }

    public LoadMonitorState monitorState() {
        return this._monitorState;
    }

    public AnalyzerState analyzerState() {
        return this._analyzerState;
    }

    public AnomalyDetectorState anomalyDetectorState() {
        return this._anomalyDetectorState;
    }

    protected String getJSONString(CruiseControlParameters parameters) {
        Gson gson = new Gson();
        Map<String, Object> jsonStructure = this.getJsonStructure(((CruiseControlStateParameters)parameters).isVerbose());
        jsonStructure.put("version", 1);
        return gson.toJson(jsonStructure);
    }

    public Map<String, Object> getJsonStructure(boolean verbose) {
        HashMap<String, Object> cruiseControlState = new HashMap<String, Object>();
        if (this._monitorState != null) {
            cruiseControlState.put(MONITOR_STATE, this._monitorState.getJsonStructure(verbose));
        }
        if (this._executorState != null) {
            cruiseControlState.put(EXECUTOR_STATE, this._executorState.getJsonStructure(verbose));
        }
        if (this._analyzerState != null) {
            cruiseControlState.put(ANALYZER_STATE, this._analyzerState.getJsonStructure(verbose));
        }
        if (this._anomalyDetectorState != null) {
            cruiseControlState.put(ANOMALY_DETECTOR_STATE, this._anomalyDetectorState.getJsonStructure());
        }
        return cruiseControlState;
    }

    protected void writeVerboseMonitorState(StringBuilder sb) {
        if (this._monitorState != null) {
            sb.append(String.format("%n%nMonitored Windows [Window End_Time=Data_Completeness]:%n", new Object[0]));
            StringJoiner joiner = new StringJoiner(", ", "{", "}");
            for (Map.Entry<Long, Float> entry : this._monitorState.monitoredWindows().entrySet()) {
                joiner.add(String.format("%d=%.3f%%", entry.getKey(), Float.valueOf(entry.getValue().floatValue() * 100.0f)));
            }
            sb.append(joiner.toString());
        }
    }

    protected void writeVerboseAnalyzerState(StringBuilder sb) {
        if (this._analyzerState != null) {
            sb.append(String.format("%n%nGoal Readiness:%n", new Object[0]));
            for (Map.Entry<Goal, Boolean> entry : this._analyzerState.readyGoals().entrySet()) {
                Goal goal = entry.getKey();
                sb.append(String.format("%50s, %s, %s%n", goal.getClass().getSimpleName(), goal.clusterModelCompletenessRequirements(), entry.getValue() != false ? "Ready" : "NotReady"));
            }
        }
    }

    protected void writeVerboseExecutorState(StringBuilder sb) {
        if (this._executorState != null) {
            if (!ExecutorState.IN_PROGRESS_STATES.contains((Object)this._executorState.state())) {
                return;
            }
            Map<ExecutionTask.TaskType, Map<ExecutionTaskState, Set<ExecutionTask>>> taskSnapshot = this._executorState.executionTasksSummary().filteredTasksByState();
            taskSnapshot.forEach((type, taskMap) -> {
                String taskTypeString = type == ExecutionTask.TaskType.INTER_BROKER_REPLICA_ACTION ? INTER_BROKER_PARTITION_MOVEMENTS : (type == ExecutionTask.TaskType.INTRA_BROKER_REPLICA_ACTION ? INTRA_BROKER_PARTITION_MOVEMENTS : LEADERSHIP_MOVEMENTS);
                sb.append(String.format("%n%n%s %s:%n", this._executorState.state() == ExecutorState.State.STOPPING_EXECUTION ? "Cancelled" : "Pending", taskTypeString));
                for (ExecutionTask task : (Set)taskMap.get((Object)ExecutionTaskState.PENDING)) {
                    sb.append(String.format("%s%n", task));
                }
                sb.append(String.format("%n%nIn progress %s:%n", taskTypeString));
                for (ExecutionTask task : (Set)taskMap.get((Object)ExecutionTaskState.IN_PROGRESS)) {
                    sb.append(String.format("%s%n", task));
                }
                sb.append(String.format("%n%nAborting %s:%n", taskTypeString));
                for (ExecutionTask task : (Set)taskMap.get((Object)ExecutionTaskState.ABORTING)) {
                    sb.append(String.format("%s%n", task));
                }
                sb.append(String.format("%n%nAborted %s:%n", taskTypeString));
                for (ExecutionTask task : (Set)taskMap.get((Object)ExecutionTaskState.ABORTED)) {
                    sb.append(String.format("%s%n", task));
                }
                sb.append(String.format("%n%nDead %s:%n", taskTypeString));
                for (ExecutionTask task : (Set)taskMap.get((Object)ExecutionTaskState.DEAD)) {
                    sb.append(String.format("%s%n", task));
                }
            });
        }
    }

    protected void writeSuperVerbose(StringBuilder sb) {
        if (this._monitorState != null) {
            LinearRegressionModelParameters.LinearRegressionModelState linearRegressionModelState;
            try {
                linearRegressionModelState = this._monitorState.detailTrainingProgress();
            }
            catch (SingularMatrixException e) {
                sb.append(String.format("%n%nFailed to calculate Linear Regression Model State with error message:%n%s", e.getMessage()));
                return;
            }
            sb.append(String.format("%n%nLinear Regression Model State:%n%s", linearRegressionModelState));
        }
    }

    protected String getPlaintext(CruiseControlParameters parameters) {
        boolean verbose = ((CruiseControlStateParameters)parameters).isVerbose();
        boolean superVerbose = ((CruiseControlStateParameters)parameters).isSuperVerbose();
        StringBuilder sb = new StringBuilder();
        sb.append(this._monitorState != null ? String.format("MonitorState: %s%n", this._monitorState) : "");
        sb.append(this._executorState == null ? "" : String.format("ExecutorState: %s%n", this._executorState.getPlaintext()));
        sb.append(this._analyzerState != null ? String.format("AnalyzerState: %s%n", this._analyzerState) : "");
        sb.append(this._anomalyDetectorState != null ? String.format("AnomalyDetectorState: %s%n", this._anomalyDetectorState) : "");
        if (verbose || superVerbose) {
            this.writeVerboseMonitorState(sb);
            this.writeVerboseAnalyzerState(sb);
            this.writeVerboseExecutorState(sb);
            if (superVerbose) {
                this.writeSuperVerbose(sb);
            }
        }
        return sb.toString();
    }

    @Override
    protected void discardIrrelevantAndCacheRelevant(CruiseControlParameters parameters) {
        this._cachedResponse = parameters.json() ? this.getJSONString(parameters) : this.getPlaintext(parameters);
        this._executorState = null;
        this._monitorState = null;
        this._analyzerState = null;
        this._anomalyDetectorState = null;
    }

    public static enum SubState {
        ANALYZER,
        MONITOR,
        EXECUTOR,
        ANOMALY_DETECTOR;

        protected static final List<SubState> CACHED_VALUES;

        public static List<SubState> cachedValues() {
            return CACHED_VALUES;
        }

        static {
            CACHED_VALUES = Collections.unmodifiableList(Arrays.asList(SubState.values()));
        }
    }
}

