/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.servlet.response;

import com.linkedin.kafka.cruisecontrol.servlet.response.JsonResponseClass;
import com.linkedin.kafka.cruisecontrol.servlet.response.JsonResponseField;
import java.util.HashMap;
import java.util.Map;

@JsonResponseClass
public class ClusterStats {
    @JsonResponseField
    public static final String BROKERS = "Brokers";
    @JsonResponseField
    public static final String TOPICS = "Topics";
    @JsonResponseField
    public static final String REPLICAS = "Replicas";
    @JsonResponseField
    public static final String LEADERS = "Leaders";
    @JsonResponseField
    public static final String AVG_REPLICATION_FACTOR = "AvgReplicationFactor";
    @JsonResponseField
    public static final String AVG_REPLICAS_PER_BROKER = "AvgReplicasPerBroker";
    @JsonResponseField
    public static final String AVG_LEADERS_PER_BROKER = "AvgLeadersPerBroker";
    @JsonResponseField
    public static final String MAX_REPLICAS_PER_BROKER = "MaxReplicasPerBroker";
    @JsonResponseField
    public static final String MAX_LEADERS_PER_BROKER = "MaxLeadersPerBroker";
    @JsonResponseField
    public static final String STD_REPLICAS_PER_BROKER = "StdReplicasPerBroker";
    @JsonResponseField
    public static final String STD_LEADERS_PER_BROKER = "StdLeadersPerBroker";
    protected final int _numBrokers;
    protected final int _numTopics;
    protected final int _numReplicas;
    protected final int _numLeaders;
    protected final double _avgReplicationFactor;
    protected final double _avgReplicasPerBroker;
    protected final double _avgLeadersPerBroker;
    protected final int _maxReplicasPerBroker;
    protected final int _maxLeadersPerBroker;
    protected final double _stdReplicasPerBroker;
    protected final double _stdLeadersPerBroker;

    public ClusterStats(int numTopics, Map<Integer, Integer> replicaCountByBrokerId, Map<Integer, Integer> leaderCountByBrokerId) {
        this._numBrokers = replicaCountByBrokerId.keySet().size();
        this._numTopics = numTopics;
        this._numReplicas = replicaCountByBrokerId.values().stream().mapToInt(i -> i).sum();
        this._numLeaders = leaderCountByBrokerId.values().stream().mapToInt(i -> i).sum();
        this._avgReplicationFactor = this._numLeaders == 0 ? 0.0 : (double)this._numReplicas / (double)this._numLeaders;
        this._avgReplicasPerBroker = (double)this._numReplicas / (double)this._numBrokers;
        int maxReplicasPerBroker = 0;
        double replicaVariance = 0.0;
        for (int replicasInBroker : replicaCountByBrokerId.values()) {
            maxReplicasPerBroker = Math.max(maxReplicasPerBroker, replicasInBroker);
            replicaVariance += Math.pow((double)replicasInBroker - this._avgReplicasPerBroker, 2.0) / (double)this._numBrokers;
        }
        this._maxReplicasPerBroker = maxReplicasPerBroker;
        this._stdReplicasPerBroker = Math.sqrt(replicaVariance);
        this._avgLeadersPerBroker = (double)this._numLeaders / (double)this._numBrokers;
        int maxLeadersPerBroker = 0;
        double leaderVariance = 0.0;
        for (int leadersInBroker : leaderCountByBrokerId.values()) {
            maxLeadersPerBroker = Math.max(maxLeadersPerBroker, leadersInBroker);
            leaderVariance += Math.pow((double)leadersInBroker - this._avgLeadersPerBroker, 2.0) / (double)this._numBrokers;
        }
        this._maxLeadersPerBroker = maxLeadersPerBroker;
        this._stdLeadersPerBroker = Math.sqrt(leaderVariance);
    }

    public Map<String, Object> getJsonStructure() {
        HashMap<String, Object> jsonMap = new HashMap<String, Object>(11);
        jsonMap.put(BROKERS, this._numBrokers);
        jsonMap.put(TOPICS, this._numTopics);
        jsonMap.put(REPLICAS, this._numReplicas);
        jsonMap.put(LEADERS, this._numLeaders);
        jsonMap.put(AVG_REPLICATION_FACTOR, this._avgReplicationFactor);
        jsonMap.put(AVG_REPLICAS_PER_BROKER, this._avgReplicasPerBroker);
        jsonMap.put(AVG_LEADERS_PER_BROKER, this._avgLeadersPerBroker);
        jsonMap.put(MAX_REPLICAS_PER_BROKER, this._maxReplicasPerBroker);
        jsonMap.put(MAX_LEADERS_PER_BROKER, this._maxLeadersPerBroker);
        jsonMap.put(STD_REPLICAS_PER_BROKER, this._stdReplicasPerBroker);
        jsonMap.put(STD_LEADERS_PER_BROKER, this._stdLeadersPerBroker);
        return jsonMap;
    }

    public void writeClusterStats(StringBuilder sb) {
        sb.append(String.format("Summary: The cluster has %d brokers, %d replicas, %d leaders, and %d topics with avg replication factor: %.2f. [Leaders/Replicas per broker] avg: %.2f/%.2f max: %d/%d std: %.2f/%.2f%n%n", this._numBrokers, this._numReplicas, this._numLeaders, this._numTopics, this._avgReplicationFactor, this._avgLeadersPerBroker, this._avgReplicasPerBroker, this._maxLeadersPerBroker, this._maxReplicasPerBroker, this._stdLeadersPerBroker, this._stdReplicasPerBroker));
    }
}

