/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.servlet.response;

import com.linkedin.kafka.cruisecontrol.servlet.response.JsonResponseClass;
import com.linkedin.kafka.cruisecontrol.servlet.response.JsonResponseField;
import com.linkedin.kafka.cruisecontrol.servlet.response.PartitionState;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.PartitionInfo;

@JsonResponseClass
public class ClusterPartitionState {
    @JsonResponseField
    public static final String OFFLINE = "offline";
    @JsonResponseField
    public static final String WITH_OFFLINE_REPLICAS = "with-offline-replicas";
    @JsonResponseField
    public static final String URP = "urp";
    @JsonResponseField
    public static final String UNDER_MIN_ISR = "under-min-isr";
    @JsonResponseField(required=false)
    public static final String OTHER = "other";
    public static final String MIN_INSYNC_REPLICAS = "min.insync.replicas";
    public static final int DEFAULT_MIN_INSYNC_REPLICAS = 1;
    protected final Set<PartitionInfo> _underReplicatedPartitions;
    protected final Set<PartitionInfo> _offlinePartitions;
    protected final Set<PartitionInfo> _otherPartitions;
    protected final Set<PartitionInfo> _partitionsWithOfflineReplicas;
    protected final Set<PartitionInfo> _underMinIsrPartitions;
    protected final Cluster _kafkaCluster;
    protected final Map<String, Properties> _allTopicConfigs;
    protected final Properties _clusterConfigs;

    public ClusterPartitionState(boolean verbose, Pattern topicPattern, Cluster kafkaCluster, Map<String, Properties> allTopicConfigs, Properties clusterConfigs) {
        this._kafkaCluster = kafkaCluster;
        this._allTopicConfigs = allTopicConfigs;
        this._clusterConfigs = clusterConfigs;
        Comparator<PartitionInfo> comparator = Comparator.comparing(PartitionInfo::topic).thenComparingInt(PartitionInfo::partition);
        this._underReplicatedPartitions = new TreeSet<PartitionInfo>(comparator);
        this._offlinePartitions = new TreeSet<PartitionInfo>(comparator);
        this._otherPartitions = new TreeSet<PartitionInfo>(comparator);
        this._partitionsWithOfflineReplicas = new TreeSet<PartitionInfo>(comparator);
        this._underMinIsrPartitions = new TreeSet<PartitionInfo>(comparator);
        this.populateKafkaPartitionState(this._underReplicatedPartitions, this._offlinePartitions, this._otherPartitions, this._partitionsWithOfflineReplicas, this._underMinIsrPartitions, verbose, topicPattern);
    }

    public Map<String, Object> getJsonStructure() {
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        jsonMap.put(OFFLINE, this.getJsonPartitions(this._offlinePartitions));
        jsonMap.put(WITH_OFFLINE_REPLICAS, this.getJsonPartitions(this._partitionsWithOfflineReplicas));
        jsonMap.put(URP, this.getJsonPartitions(this._underReplicatedPartitions));
        jsonMap.put(UNDER_MIN_ISR, this.getJsonPartitions(this._underMinIsrPartitions));
        if (!this._otherPartitions.isEmpty()) {
            jsonMap.put(OTHER, this.getJsonPartitions(this._otherPartitions));
        }
        return jsonMap;
    }

    protected void populateKafkaPartitionState(Set<PartitionInfo> underReplicatedPartitions, Set<PartitionInfo> offlinePartitions, Set<PartitionInfo> otherPartitions, Set<PartitionInfo> partitionsWithOfflineReplicas, Set<PartitionInfo> underMinIsrPartitions, boolean verbose, Pattern topicPattern) {
        for (String topic : this._kafkaCluster.topics()) {
            if (topicPattern != null && !topicPattern.matcher(topic).matches()) continue;
            int minInsyncReplicas = this.minInsyncReplicas(topic);
            for (PartitionInfo partitionInfo : this._kafkaCluster.partitionsForTopic(topic)) {
                boolean isOffline;
                boolean hasOfflineReplica;
                boolean isURP;
                int numInsyncReplicas = partitionInfo.inSyncReplicas().length;
                boolean bl = isURP = numInsyncReplicas != partitionInfo.replicas().length;
                if (numInsyncReplicas < minInsyncReplicas) {
                    underMinIsrPartitions.add(partitionInfo);
                }
                if (!isURP && !verbose) continue;
                boolean bl2 = hasOfflineReplica = partitionInfo.offlineReplicas().length != 0;
                if (hasOfflineReplica) {
                    partitionsWithOfflineReplicas.add(partitionInfo);
                }
                boolean bl3 = isOffline = partitionInfo.inSyncReplicas().length == 0;
                if (isOffline) {
                    offlinePartitions.add(partitionInfo);
                    continue;
                }
                if (isURP) {
                    underReplicatedPartitions.add(partitionInfo);
                    continue;
                }
                otherPartitions.add(partitionInfo);
            }
        }
    }

    protected int minInsyncReplicas(String topic) {
        Properties topicLevelConfig = this._allTopicConfigs.get(topic);
        if (topicLevelConfig != null && topicLevelConfig.get(MIN_INSYNC_REPLICAS) != null) {
            return Integer.parseInt(topicLevelConfig.getProperty(MIN_INSYNC_REPLICAS));
        }
        if (this._clusterConfigs != null && this._clusterConfigs.get(MIN_INSYNC_REPLICAS) != null) {
            return Integer.parseInt(this._clusterConfigs.getProperty(MIN_INSYNC_REPLICAS));
        }
        return 1;
    }

    protected List<Object> getJsonPartitions(Set<PartitionInfo> partitions) {
        ArrayList<Object> partitionList = new ArrayList<Object>();
        for (PartitionInfo partitionInfo : partitions) {
            partitionList.add(new PartitionState(partitionInfo).getJsonStructure());
        }
        return partitionList;
    }

    public void writePartitionSummary(StringBuilder sb, boolean verbose) {
        int topicNameLength = this._kafkaCluster.topics().stream().mapToInt(String::length).max().orElse(20) + 5;
        String initMessage = verbose ? "All Partitions in the Cluster (verbose):" : "Under Replicated, Offline, and Under MinIsr Partitions:";
        sb.append(String.format("%n%s%n%" + topicNameLength + "s%10s%10s%30s%30s%25s%25s%n", initMessage, "TOPIC", "PARTITION", "LEADER", "REPLICAS", "IN-SYNC", "OUT-OF-SYNC", "OFFLINE"));
        sb.append(String.format("Offline Partitions:%n", new Object[0]));
        this.writeKafkaPartitionState(sb, this._offlinePartitions, topicNameLength);
        sb.append(String.format("Partitions with Offline Replicas:%n", new Object[0]));
        this.writeKafkaPartitionState(sb, this._partitionsWithOfflineReplicas, topicNameLength);
        sb.append(String.format("Under Replicated Partitions:%n", new Object[0]));
        this.writeKafkaPartitionState(sb, this._underReplicatedPartitions, topicNameLength);
        sb.append(String.format("Under MinIsr Partitions:%n", new Object[0]));
        this.writeKafkaPartitionState(sb, this._underMinIsrPartitions, topicNameLength);
        if (verbose) {
            sb.append(String.format("Other Partitions:%n", new Object[0]));
            this.writeKafkaPartitionState(sb, this._otherPartitions, topicNameLength);
        }
    }

    protected void writeKafkaPartitionState(StringBuilder sb, Set<PartitionInfo> partitions, int topicNameLength) {
        for (PartitionInfo partitionInfo : partitions) {
            sb.append(new PartitionState(partitionInfo).writeKafkaPartitionState(topicNameLength));
        }
    }
}

