/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.servlet.response;

import com.google.gson.Gson;
import com.linkedin.cruisecontrol.detector.AnomalyType;
import com.linkedin.cruisecontrol.servlet.parameters.CruiseControlParameters;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.executor.ConcurrencyType;
import com.linkedin.kafka.cruisecontrol.servlet.response.AbstractCruiseControlResponse;
import com.linkedin.kafka.cruisecontrol.servlet.response.JsonResponseClass;
import com.linkedin.kafka.cruisecontrol.servlet.response.JsonResponseField;
import java.util.HashMap;
import java.util.Map;

@JsonResponseClass
public class AdminResult
extends AbstractCruiseControlResponse {
    @JsonResponseField(required=false)
    protected static final String SELF_HEALING_ENABLED_BEFORE = "selfHealingEnabledBefore";
    @JsonResponseField(required=false)
    protected static final String SELF_HEALING_ENABLED_AFTER = "selfHealingEnabledAfter";
    @JsonResponseField(required=false)
    protected static final String ONGOING_CONCURRENCY_CHANGE_REQUEST = "ongoingConcurrencyChangeRequest";
    @JsonResponseField(required=false)
    protected static final String DROP_RECENT_BROKERS_REQUEST = "dropRecentBrokersRequest";
    @JsonResponseField(required=false)
    protected static final String CONCURRENCY_ADJUSTER_ENABLED_BEFORE = "concurrencyAdjusterEnabledBefore";
    @JsonResponseField(required=false)
    protected static final String CONCURRENCY_ADJUSTER_ENABLED_AFTER = "concurrencyAdjusterEnabledAfter";
    protected final Map<AnomalyType, Boolean> _selfHealingEnabledBefore;
    protected final Map<AnomalyType, Boolean> _selfHealingEnabledAfter;
    protected String _ongoingConcurrencyChangeRequest;
    protected String _dropRecentBrokersRequest;
    protected final Map<ConcurrencyType, Boolean> _concurrencyAdjusterEnabledBefore;
    protected final Map<ConcurrencyType, Boolean> _concurrencyAdjusterEnabledAfter;

    public AdminResult(Map<AnomalyType, Boolean> selfHealingEnabledBefore, Map<AnomalyType, Boolean> selfHealingEnabledAfter, String ongoingConcurrencyChangeRequest, String dropRecentBrokersRequest, Map<ConcurrencyType, Boolean> concurrencyAdjusterEnabledBefore, Map<ConcurrencyType, Boolean> concurrencyAdjusterEnabledAfter, KafkaCruiseControlConfig config) {
        super(config);
        this._selfHealingEnabledBefore = selfHealingEnabledBefore;
        this._selfHealingEnabledAfter = selfHealingEnabledAfter;
        this._ongoingConcurrencyChangeRequest = ongoingConcurrencyChangeRequest;
        this._dropRecentBrokersRequest = dropRecentBrokersRequest;
        this._concurrencyAdjusterEnabledBefore = concurrencyAdjusterEnabledBefore;
        this._concurrencyAdjusterEnabledAfter = concurrencyAdjusterEnabledAfter;
    }

    @Override
    protected void discardIrrelevantAndCacheRelevant(CruiseControlParameters parameters) {
        this._cachedResponse = parameters.json() ? this.getJSONString() : this.getPlaintext();
        this._selfHealingEnabledBefore.clear();
        this._selfHealingEnabledAfter.clear();
        this._ongoingConcurrencyChangeRequest = null;
        this._dropRecentBrokersRequest = null;
        this._concurrencyAdjusterEnabledBefore.clear();
        this._concurrencyAdjusterEnabledAfter.clear();
    }

    protected String getJSONString() {
        HashMap<String, Object> jsonStructure = new HashMap<String, Object>(7);
        if (!this._selfHealingEnabledBefore.isEmpty()) {
            jsonStructure.put(SELF_HEALING_ENABLED_BEFORE, this._selfHealingEnabledBefore);
            jsonStructure.put(SELF_HEALING_ENABLED_AFTER, this._selfHealingEnabledAfter);
        }
        if (this._ongoingConcurrencyChangeRequest != null && !this._ongoingConcurrencyChangeRequest.isEmpty()) {
            jsonStructure.put(ONGOING_CONCURRENCY_CHANGE_REQUEST, this._ongoingConcurrencyChangeRequest);
        }
        if (this._dropRecentBrokersRequest != null && !this._dropRecentBrokersRequest.isEmpty()) {
            jsonStructure.put(DROP_RECENT_BROKERS_REQUEST, this._dropRecentBrokersRequest);
        }
        if (!this._concurrencyAdjusterEnabledBefore.isEmpty()) {
            jsonStructure.put(CONCURRENCY_ADJUSTER_ENABLED_BEFORE, this._concurrencyAdjusterEnabledBefore);
            jsonStructure.put(CONCURRENCY_ADJUSTER_ENABLED_AFTER, this._concurrencyAdjusterEnabledAfter);
        }
        jsonStructure.put("version", 1);
        return new Gson().toJson(jsonStructure);
    }

    protected String getPlaintext() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("{%n", new Object[0]));
        if (!this._selfHealingEnabledBefore.isEmpty()) {
            sb.append(String.format("%s: %s, %s: %s%n", SELF_HEALING_ENABLED_BEFORE, this._selfHealingEnabledBefore, SELF_HEALING_ENABLED_AFTER, this._selfHealingEnabledAfter));
        }
        if (this._ongoingConcurrencyChangeRequest != null && !this._ongoingConcurrencyChangeRequest.isEmpty()) {
            sb.append(String.format("%s: %s%n", ONGOING_CONCURRENCY_CHANGE_REQUEST, this._ongoingConcurrencyChangeRequest));
        }
        if (this._dropRecentBrokersRequest != null && !this._dropRecentBrokersRequest.isEmpty()) {
            sb.append(String.format("%s: %s%n", DROP_RECENT_BROKERS_REQUEST, this._dropRecentBrokersRequest));
        }
        if (!this._concurrencyAdjusterEnabledBefore.isEmpty()) {
            sb.append(String.format("%s: %s, %s: %s%n", CONCURRENCY_ADJUSTER_ENABLED_BEFORE, this._concurrencyAdjusterEnabledBefore, CONCURRENCY_ADJUSTER_ENABLED_AFTER, this._concurrencyAdjusterEnabledAfter));
        }
        sb.append("}");
        return sb.toString();
    }
}

