/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.servlet.purgatory;

import com.linkedin.cruisecontrol.servlet.EndPoint;
import com.linkedin.cruisecontrol.servlet.parameters.CruiseControlParameters;
import com.linkedin.kafka.cruisecontrol.servlet.KafkaCruiseControlServletUtils;
import com.linkedin.kafka.cruisecontrol.servlet.parameters.ParameterUtils;
import com.linkedin.kafka.cruisecontrol.servlet.purgatory.ReviewStatus;
import com.linkedin.kafka.cruisecontrol.servlet.response.JsonResponseClass;
import com.linkedin.kafka.cruisecontrol.servlet.response.JsonResponseField;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

@JsonResponseClass
public class RequestInfo {
    @JsonResponseField
    public static final String ID = "Id";
    @JsonResponseField
    public static final String SUBMITTER_ADDRESS = "SubmitterAddress";
    @JsonResponseField
    public static final String SUBMISSION_TIME_MS = "SubmissionTimeMs";
    @JsonResponseField
    public static final String STATUS = "Status";
    @JsonResponseField
    public static final String ENDPOINT_WITH_PARAMS = "EndpointWithParams";
    @JsonResponseField
    public static final String REASON = "Reason";
    private static final String INIT_REASON = "Awaiting review.";
    private static final String FINAL_REASON = "Submitted approved request.";
    private static final Map<ReviewStatus, Set<ReviewStatus>> VALID_TRANSFER = new HashMap<ReviewStatus, Set<ReviewStatus>>();
    private final String _submitterAddress;
    private final long _submissionTimeMs;
    private final Map<String, String[]> _parameterMap;
    private final EndPoint _endPoint;
    private final CruiseControlParameters _parameters;
    private volatile ReviewStatus _status;
    private volatile String _reason;
    private volatile boolean _accessToAlreadySubmittedRequest;

    public <P extends CruiseControlParameters> RequestInfo(HttpServletRequest request, P parameters) {
        if (request == null) {
            throw new IllegalArgumentException("Request is missing from the request info.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter is missing from the request info.");
        }
        this._submitterAddress = KafkaCruiseControlServletUtils.getClientIpAddress(request);
        this._submissionTimeMs = System.currentTimeMillis();
        this._parameterMap = request.getParameterMap();
        this._endPoint = ParameterUtils.endPoint(request);
        this._parameters = parameters;
        this._status = ReviewStatus.PENDING_REVIEW;
        this._reason = INIT_REASON;
        this._accessToAlreadySubmittedRequest = false;
    }

    public CruiseControlParameters parameters() {
        return this._parameters;
    }

    public String submitterAddress() {
        return this._submitterAddress;
    }

    public long submissionTimeMs() {
        return this._submissionTimeMs;
    }

    public String reason() {
        return this._reason;
    }

    public Map<String, String[]> parameterMap() {
        return this._parameterMap;
    }

    public String endpointWithParams() {
        StringBuilder sb = new StringBuilder(this._endPoint.toString());
        String queryParamDelimiter = "?";
        for (Map.Entry<String, String[]> paramSet : this._parameterMap.entrySet()) {
            for (String paramValue : paramSet.getValue()) {
                sb.append(queryParamDelimiter).append(paramSet.getKey()).append("=").append(paramValue);
                if (!queryParamDelimiter.equals("?")) continue;
                queryParamDelimiter = "&";
            }
        }
        return sb.toString();
    }

    public EndPoint endPoint() {
        return this._endPoint;
    }

    public ReviewStatus status() {
        return this._status;
    }

    void applyReview(ReviewStatus targetStatus, String reason) {
        if (!this.canTransferToStatus(targetStatus)) {
            throw new IllegalStateException("Cannot mark a task in " + this._status + " to " + targetStatus + " status. The valid target statuses are " + this.validTargetStatus());
        }
        this._status = targetStatus;
        this._reason = reason;
    }

    void submitReview(int reviewId) {
        this.applyReview(ReviewStatus.SUBMITTED, FINAL_REASON);
        this._parameters.setReviewId(reviewId);
    }

    public void setAccessToAlreadySubmittedRequest() {
        this._accessToAlreadySubmittedRequest = true;
    }

    public boolean accessToAlreadySubmittedRequest() {
        return this._accessToAlreadySubmittedRequest;
    }

    private boolean canTransferToStatus(ReviewStatus targetStatus) {
        return VALID_TRANSFER.get((Object)this._status).contains((Object)targetStatus);
    }

    private Set<ReviewStatus> validTargetStatus() {
        return Collections.unmodifiableSet(VALID_TRANSFER.get((Object)this._status));
    }

    public Map<String, Object> getJsonStructure(Integer reviewId) {
        HashMap<String, Object> jsonMap = new HashMap<String, Object>(6);
        jsonMap.put(ID, reviewId);
        jsonMap.put(SUBMITTER_ADDRESS, this._submitterAddress);
        jsonMap.put(SUBMISSION_TIME_MS, this._submissionTimeMs);
        jsonMap.put(STATUS, this._status.toString());
        jsonMap.put(ENDPOINT_WITH_PARAMS, this.endpointWithParams());
        jsonMap.put(REASON, this._reason);
        return jsonMap;
    }

    static {
        VALID_TRANSFER.put(ReviewStatus.PENDING_REVIEW, new HashSet<ReviewStatus>(Arrays.asList(ReviewStatus.APPROVED, ReviewStatus.DISCARDED)));
        VALID_TRANSFER.put(ReviewStatus.APPROVED, new HashSet<ReviewStatus>(Arrays.asList(ReviewStatus.DISCARDED, ReviewStatus.SUBMITTED)));
        VALID_TRANSFER.put(ReviewStatus.SUBMITTED, Collections.emptySet());
        VALID_TRANSFER.put(ReviewStatus.DISCARDED, Collections.emptySet());
    }
}

