/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.servlet.purgatory;

import com.linkedin.cruisecontrol.servlet.parameters.CruiseControlParameters;
import com.linkedin.kafka.cruisecontrol.common.KafkaCruiseControlThreadFactory;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.servlet.CruiseControlEndPoint;
import com.linkedin.kafka.cruisecontrol.servlet.KafkaCruiseControlServletUtils;
import com.linkedin.kafka.cruisecontrol.servlet.UserRequestException;
import com.linkedin.kafka.cruisecontrol.servlet.UserTaskManager;
import com.linkedin.kafka.cruisecontrol.servlet.parameters.ParameterUtils;
import com.linkedin.kafka.cruisecontrol.servlet.purgatory.RequestInfo;
import com.linkedin.kafka.cruisecontrol.servlet.purgatory.ReviewStatus;
import com.linkedin.kafka.cruisecontrol.servlet.response.ReviewResult;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Purgatory
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(Purgatory.class);
    private static final long PURGATORY_CLEANER_PERIOD_SECONDS = 10L;
    private static final long PURGATORY_CLEANER_INITIAL_DELAY_SECONDS = 0L;
    private int _requestId = 0;
    private final long _purgatoryRetentionTimeMs;
    private final Map<Integer, RequestInfo> _requestInfoById;
    private final ScheduledExecutorService _purgatoryCleaner = Executors.newSingleThreadScheduledExecutor(new KafkaCruiseControlThreadFactory("PurgatoryCleaner", true, null));
    private final KafkaCruiseControlConfig _config;

    public Purgatory(KafkaCruiseControlConfig config) {
        this._config = config;
        this._purgatoryRetentionTimeMs = config.getLong("two.step.purgatory.retention.time.ms");
        final int purgatoryMaxCachedRequests = config.getInt("two.step.purgatory.max.requests");
        this._requestInfoById = new LinkedHashMap<Integer, RequestInfo>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Integer, RequestInfo> eldest) {
                return this.size() > purgatoryMaxCachedRequests;
            }
        };
        this._purgatoryCleaner.scheduleAtFixedRate(new PurgatoryCleaner(), 0L, 10L, TimeUnit.SECONDS);
    }

    private synchronized <P extends CruiseControlParameters> ReviewResult addRequest(HttpServletRequest request, P parameters) {
        if (!request.getMethod().equals("POST")) {
            throw new IllegalArgumentException(String.format("Purgatory can only contain POST request (Attempted to add: %s).", KafkaCruiseControlServletUtils.httpServletRequestToString(request)));
        }
        RequestInfo requestInfo = new RequestInfo(request, parameters);
        this._requestInfoById.put(this._requestId, requestInfo);
        HashMap<Integer, RequestInfo> requestInfoById = new HashMap<Integer, RequestInfo>();
        requestInfoById.put(this._requestId, requestInfo);
        HashSet<Integer> filteredRequestIds = new HashSet<Integer>();
        filteredRequestIds.add(this._requestId);
        ReviewResult result = new ReviewResult(requestInfoById, filteredRequestIds, this._config);
        ++this._requestId;
        return result;
    }

    public CruiseControlParameters maybeAddToPurgatory(HttpServletRequest request, HttpServletResponse response, String classConfig, Map<String, Object> parameterConfigOverrides, UserTaskManager userTaskManager) throws IOException {
        Integer reviewId = ParameterUtils.reviewId(request, true);
        if (reviewId != null) {
            RequestInfo requestInfo = this.submit(reviewId, request);
            Purgatory.sanityCheckSubmittedRequest(request, requestInfo, userTaskManager);
            return requestInfo.parameters();
        }
        CruiseControlParameters parameters = this._config.getConfiguredInstance(classConfig, CruiseControlParameters.class, parameterConfigOverrides);
        if (ParameterUtils.hasValidParameterNames(request, response, this._config, parameters) && !parameters.parseParameters(response)) {
            ReviewResult reviewResult = this.addRequest(request, parameters);
            reviewResult.writeSuccessResponse(parameters, response);
            LOG.info("Added request {} (parameters: {}) to purgatory.", (Object)request.getPathInfo(), (Object)request.getParameterMap());
        }
        return null;
    }

    private static void sanityCheckSubmittedRequest(HttpServletRequest request, RequestInfo requestInfo, UserTaskManager userTaskManager) {
        if (requestInfo.accessToAlreadySubmittedRequest() && userTaskManager.getUserTaskByUserTaskId(userTaskManager.getUserTaskId(request), request) == null) {
            throw new UserRequestException(String.format("Attempt to start a new user task with an already submitted review. If you are trying to retrieve the result of a submitted execution, please use its UUID in your request header via %s flag. If you are starting a new execution with the same parameters, please submit a new review request and get approval for it.", "User-Task-ID"));
        }
    }

    public synchronized RequestInfo submit(int reviewId, HttpServletRequest request) {
        RequestInfo requestInfo = this._requestInfoById.get(reviewId);
        if (requestInfo == null) {
            throw new UserRequestException(String.format("No request with review id %d exists in purgatory. Please use %s endpoint to check for the current requests awaiting review in purgatory.", new Object[]{reviewId, CruiseControlEndPoint.REVIEW}));
        }
        CruiseControlEndPoint endpoint = ParameterUtils.endPoint(request);
        if (requestInfo.endPoint() != endpoint) {
            throw new UserRequestException(String.format("Request with review id %d is associated with %s endpoint, but the given request has %s endpoint.Please use %s endpoint to check for the current requests awaiting review in purgatory.", new Object[]{reviewId, requestInfo.endPoint(), endpoint, CruiseControlEndPoint.REVIEW}));
        }
        if (requestInfo.status() == ReviewStatus.SUBMITTED) {
            LOG.info("Request {} has already been submitted (review: {}).", (Object)requestInfo.endpointWithParams(), (Object)reviewId);
            requestInfo.setAccessToAlreadySubmittedRequest();
        } else {
            requestInfo.submitReview(reviewId);
            LOG.info("Submitted request {} for execution (review: {}).", (Object)requestInfo.endpointWithParams(), (Object)reviewId);
        }
        return requestInfo;
    }

    public synchronized RequestInfo removeSubmitted(int reviewId) {
        RequestInfo requestInfo = this._requestInfoById.get(reviewId);
        if (requestInfo == null) {
            return null;
        }
        if (requestInfo.status() != ReviewStatus.SUBMITTED) {
            throw new IllegalStateException(String.format("Attempt to remove request associated with review id %d from purgatory. Status (current %s, expected: %s).", new Object[]{reviewId, requestInfo.status(), ReviewStatus.SUBMITTED}));
        }
        return this._requestInfoById.remove(reviewId);
    }

    public synchronized ReviewResult reviewBoard(Set<Integer> reviewIds) {
        return new ReviewResult(new HashMap<Integer, RequestInfo>(this._requestInfoById), reviewIds, this._config);
    }

    public synchronized ReviewResult applyReview(Map<ReviewStatus, Set<Integer>> requestIdsByTargetState, String reason) {
        HashSet<Integer> reviewedRequestIds = new HashSet<Integer>();
        for (Map.Entry<ReviewStatus, Set<Integer>> entry : requestIdsByTargetState.entrySet()) {
            Set<Integer> requestIds = entry.getValue();
            if (!this._requestInfoById.keySet().containsAll(requestIds)) {
                throw new IllegalStateException(String.format("Review contains request ids (%s) that do not exist in purgatory.", requestIds.removeAll(this._requestInfoById.keySet())));
            }
            ReviewStatus targetReviewStatus = entry.getKey();
            requestIds.forEach(requestId -> this._requestInfoById.get(requestId).applyReview(targetReviewStatus, reason));
            reviewedRequestIds.addAll(requestIds);
        }
        return new ReviewResult(new HashMap<Integer, RequestInfo>(this._requestInfoById), reviewedRequestIds, this._config);
    }

    private synchronized void removeOldRequests() {
        LOG.debug("Remove old requests from purgatory.");
        this._requestInfoById.entrySet().removeIf(entry -> ((RequestInfo)entry.getValue()).submissionTimeMs() + this._purgatoryRetentionTimeMs < System.currentTimeMillis());
    }

    @Override
    public void close() {
        this._purgatoryCleaner.shutdownNow();
        this._requestInfoById.clear();
    }

    private class PurgatoryCleaner
    implements Runnable {
        private PurgatoryCleaner() {
        }

        @Override
        public void run() {
            try {
                Purgatory.this.removeOldRequests();
            }
            catch (Throwable t) {
                LOG.warn("Received exception when trying to remove old requests from purgatory.", t);
            }
        }
    }
}

