/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.servlet.parameters;

import com.linkedin.cruisecontrol.detector.AnomalyType;
import com.linkedin.kafka.cruisecontrol.servlet.parameters.AbstractParameters;
import com.linkedin.kafka.cruisecontrol.servlet.parameters.ParameterUtils;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class UpdateSelfHealingParameters
extends AbstractParameters {
    protected static final SortedSet<String> CASE_INSENSITIVE_PARAMETER_NAMES;
    protected Set<AnomalyType> _disableSelfHealingFor;
    protected Set<AnomalyType> _enableSelfHealingFor;

    protected UpdateSelfHealingParameters() {
    }

    @Override
    protected void initParameters() throws UnsupportedEncodingException {
        super.initParameters();
        Map<Boolean, Set<AnomalyType>> selfHealingFor = ParameterUtils.selfHealingFor(this._request);
        this._enableSelfHealingFor = selfHealingFor.get(true);
        this._disableSelfHealingFor = selfHealingFor.get(false);
    }

    public static UpdateSelfHealingParameters maybeBuildUpdateSelfHealingParameters(Map<String, ?> configs) throws UnsupportedEncodingException {
        UpdateSelfHealingParameters selfHealingUpdateParameters = new UpdateSelfHealingParameters();
        selfHealingUpdateParameters.configure(configs);
        selfHealingUpdateParameters.initParameters();
        if (selfHealingUpdateParameters.enableSelfHealingFor().isEmpty() && selfHealingUpdateParameters.disableSelfHealingFor().isEmpty()) {
            return null;
        }
        return selfHealingUpdateParameters;
    }

    public Set<AnomalyType> disableSelfHealingFor() {
        return this._disableSelfHealingFor;
    }

    public Set<AnomalyType> enableSelfHealingFor() {
        return this._enableSelfHealingFor;
    }

    public SortedSet<String> caseInsensitiveParameterNames() {
        return CASE_INSENSITIVE_PARAMETER_NAMES;
    }

    static {
        TreeSet<String> validParameterNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        validParameterNames.add("disable_self_healing_for");
        validParameterNames.add("enable_self_healing_for");
        validParameterNames.addAll(AbstractParameters.CASE_INSENSITIVE_PARAMETER_NAMES);
        CASE_INSENSITIVE_PARAMETER_NAMES = Collections.unmodifiableSortedSet(validParameterNames);
    }
}

