/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.servlet.parameters;

import com.linkedin.kafka.cruisecontrol.executor.ConcurrencyType;
import com.linkedin.kafka.cruisecontrol.servlet.parameters.AbstractParameters;
import com.linkedin.kafka.cruisecontrol.servlet.parameters.ParameterUtils;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class UpdateConcurrencyAdjusterParameters
extends AbstractParameters {
    protected static final SortedSet<String> CASE_INSENSITIVE_PARAMETER_NAMES;
    protected Set<ConcurrencyType> _disableConcurrencyAdjusterFor;
    protected Set<ConcurrencyType> _enableConcurrencyAdjusterFor;

    protected UpdateConcurrencyAdjusterParameters() {
    }

    @Override
    protected void initParameters() throws UnsupportedEncodingException {
        super.initParameters();
        Map<Boolean, Set<ConcurrencyType>> concurrencyAdjusterFor = ParameterUtils.concurrencyAdjusterFor(this._request);
        this._enableConcurrencyAdjusterFor = concurrencyAdjusterFor.get(true);
        this._disableConcurrencyAdjusterFor = concurrencyAdjusterFor.get(false);
    }

    public static UpdateConcurrencyAdjusterParameters maybeBuildUpdateConcurrencyAdjusterParameters(Map<String, ?> configs) throws UnsupportedEncodingException {
        UpdateConcurrencyAdjusterParameters updateConcurrencyAdjusterParameters = new UpdateConcurrencyAdjusterParameters();
        updateConcurrencyAdjusterParameters.configure(configs);
        updateConcurrencyAdjusterParameters.initParameters();
        if (updateConcurrencyAdjusterParameters.enableConcurrencyAdjusterFor().isEmpty() && updateConcurrencyAdjusterParameters.disableConcurrencyAdjusterFor().isEmpty()) {
            return null;
        }
        return updateConcurrencyAdjusterParameters;
    }

    public Set<ConcurrencyType> disableConcurrencyAdjusterFor() {
        return this._disableConcurrencyAdjusterFor;
    }

    public Set<ConcurrencyType> enableConcurrencyAdjusterFor() {
        return this._enableConcurrencyAdjusterFor;
    }

    public SortedSet<String> caseInsensitiveParameterNames() {
        return CASE_INSENSITIVE_PARAMETER_NAMES;
    }

    static {
        TreeSet<String> validParameterNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        validParameterNames.add("disable_concurrency_adjuster_for");
        validParameterNames.add("enable_concurrency_adjuster_for");
        validParameterNames.addAll(AbstractParameters.CASE_INSENSITIVE_PARAMETER_NAMES);
        CASE_INSENSITIVE_PARAMETER_NAMES = Collections.unmodifiableSortedSet(validParameterNames);
    }
}

