/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.servlet.parameters;

import com.linkedin.kafka.cruisecontrol.servlet.UserRequestException;
import com.linkedin.kafka.cruisecontrol.servlet.parameters.AbstractParameters;
import com.linkedin.kafka.cruisecontrol.servlet.parameters.ParameterUtils;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public class TrainParameters
extends AbstractParameters {
    protected static final SortedSet<String> CASE_INSENSITIVE_PARAMETER_NAMES;
    protected Long _startMs;
    protected Long _endMs;

    @Override
    protected void initParameters() throws UnsupportedEncodingException {
        super.initParameters();
        this._startMs = ParameterUtils.startMsOrDefault(this._request, null);
        this._endMs = ParameterUtils.endMsOrDefault(this._request, null);
        if (this._startMs == null || this._endMs == null) {
            throw new UserRequestException("Missing start or end parameter.");
        }
        ParameterUtils.validateTimeRange(this._startMs, this._endMs);
    }

    public Long startMs() {
        return this._startMs;
    }

    public Long endMs() {
        return this._endMs;
    }

    @Override
    public void configure(Map<String, ?> configs) {
        super.configure(configs);
    }

    public SortedSet<String> caseInsensitiveParameterNames() {
        return CASE_INSENSITIVE_PARAMETER_NAMES;
    }

    static {
        TreeSet<String> validParameterNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        validParameterNames.add("start");
        validParameterNames.add("end");
        validParameterNames.addAll(AbstractParameters.CASE_INSENSITIVE_PARAMETER_NAMES);
        CASE_INSENSITIVE_PARAMETER_NAMES = Collections.unmodifiableSortedSet(validParameterNames);
    }
}

