/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.servlet.parameters;

import com.linkedin.kafka.cruisecontrol.executor.strategy.ReplicaMovementStrategy;
import com.linkedin.kafka.cruisecontrol.servlet.UserRequestException;
import com.linkedin.kafka.cruisecontrol.servlet.parameters.AbstractParameters;
import com.linkedin.kafka.cruisecontrol.servlet.parameters.ParameterUtils;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;

public class TopicReplicationFactorChangeParameters
extends AbstractParameters {
    protected static final SortedSet<String> CASE_INSENSITIVE_PARAMETER_NAMES;
    protected Map<Short, Pattern> _topicPatternByReplicationFactor;
    protected boolean _skipRackAwarenessCheck;
    protected Integer _concurrentInterBrokerPartitionMovements;
    protected Integer _concurrentLeaderMovements;
    protected Long _executionProgressCheckIntervalMs;
    protected boolean _skipHardGoalCheck;
    protected ReplicaMovementStrategy _replicaMovementStrategy;
    protected Long _replicationThrottle;

    protected TopicReplicationFactorChangeParameters() {
    }

    @Override
    protected void initParameters() throws UnsupportedEncodingException {
        super.initParameters();
        this._topicPatternByReplicationFactor = ParameterUtils.topicPatternByReplicationFactor(this._request);
        if (this._topicPatternByReplicationFactor.keySet().stream().anyMatch(rf -> rf < 1)) {
            throw new UserRequestException("Target replication factor cannot be set to smaller than 1.");
        }
        this._skipRackAwarenessCheck = ParameterUtils.skipRackAwarenessCheck(this._request);
        this._concurrentInterBrokerPartitionMovements = ParameterUtils.concurrentMovements(this._request, true, false);
        this._concurrentLeaderMovements = ParameterUtils.concurrentMovements(this._request, false, false);
        this._executionProgressCheckIntervalMs = ParameterUtils.executionProgressCheckIntervalMs(this._request);
        this._skipHardGoalCheck = ParameterUtils.skipHardGoalCheck(this._request);
        this._replicaMovementStrategy = ParameterUtils.getReplicaMovementStrategy(this._request, this._config);
        this._replicationThrottle = ParameterUtils.replicationThrottle(this._request, this._config);
    }

    static TopicReplicationFactorChangeParameters maybeBuildTopicReplicationFactorChangeParameters(Map<String, ?> configs) throws UnsupportedEncodingException {
        TopicReplicationFactorChangeParameters topicReplicationFactorChangeParameters = new TopicReplicationFactorChangeParameters();
        topicReplicationFactorChangeParameters.configure(configs);
        topicReplicationFactorChangeParameters.initParameters();
        if (topicReplicationFactorChangeParameters.topicPatternByReplicationFactor().isEmpty()) {
            return null;
        }
        return topicReplicationFactorChangeParameters;
    }

    public Map<Short, Pattern> topicPatternByReplicationFactor() {
        return this._topicPatternByReplicationFactor;
    }

    public boolean skipRackAwarenessCheck() {
        return this._skipRackAwarenessCheck;
    }

    public Integer concurrentInterBrokerPartitionMovements() {
        return this._concurrentInterBrokerPartitionMovements;
    }

    public Long executionProgressCheckIntervalMs() {
        return this._executionProgressCheckIntervalMs;
    }

    public Integer concurrentLeaderMovements() {
        return this._concurrentLeaderMovements;
    }

    public boolean skipHardGoalCheck() {
        return this._skipHardGoalCheck;
    }

    public ReplicaMovementStrategy replicaMovementStrategy() {
        return this._replicaMovementStrategy;
    }

    public Long replicationThrottle() {
        return this._replicationThrottle;
    }

    public SortedSet<String> caseInsensitiveParameterNames() {
        return CASE_INSENSITIVE_PARAMETER_NAMES;
    }

    static {
        TreeSet<String> validParameterNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        validParameterNames.add("topic");
        validParameterNames.add("replication_factor");
        validParameterNames.add("skip_rack_awareness_check");
        validParameterNames.add("concurrent_partition_movements_per_broker");
        validParameterNames.add("concurrent_leader_movements");
        validParameterNames.add("execution_progress_check_interval_ms");
        validParameterNames.add("skip_hard_goal_check");
        validParameterNames.add("replica_movement_strategies");
        validParameterNames.add("replication_throttle");
        validParameterNames.addAll(AbstractParameters.CASE_INSENSITIVE_PARAMETER_NAMES);
        CASE_INSENSITIVE_PARAMETER_NAMES = Collections.unmodifiableSortedSet(validParameterNames);
    }
}

