/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.servlet.parameters;

import com.linkedin.kafka.cruisecontrol.servlet.UserRequestException;
import com.linkedin.kafka.cruisecontrol.servlet.parameters.GoalBasedOptimizationParameters;
import com.linkedin.kafka.cruisecontrol.servlet.parameters.ParameterUtils;
import com.linkedin.kafka.cruisecontrol.servlet.parameters.TopicReplicationFactorChangeParameters;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public class TopicConfigurationParameters
extends GoalBasedOptimizationParameters {
    protected static final SortedSet<String> CASE_INSENSITIVE_PARAMETER_NAMES;
    protected Integer _reviewId;
    protected boolean _dryRun;
    protected boolean _stopOngoingExecution;
    protected String _reason;
    protected TopicReplicationFactorChangeParameters _topicReplicationFactorChangeParameters;
    protected Map<String, ?> _configs;

    @Override
    protected void initParameters() throws UnsupportedEncodingException {
        super.initParameters();
        boolean twoStepVerificationEnabled = this._config.getBoolean("two.step.verification.enabled");
        this._reviewId = ParameterUtils.reviewId(this._request, twoStepVerificationEnabled);
        this._dryRun = ParameterUtils.getDryRun(this._request);
        boolean requestReasonRequired = this._config.getBoolean("request.reason.required");
        this._reason = ParameterUtils.reason(this._request, requestReasonRequired && !this._dryRun);
        this._stopOngoingExecution = ParameterUtils.stopOngoingExecution(this._request);
        if (this._stopOngoingExecution && this._dryRun) {
            throw new UserRequestException(String.format("%s and %s cannot both be set to true.", "stop_ongoing_execution", "dryrun"));
        }
        this._topicReplicationFactorChangeParameters = TopicReplicationFactorChangeParameters.maybeBuildTopicReplicationFactorChangeParameters(this._configs);
        if (ParameterUtils.areAllParametersNull(this._topicReplicationFactorChangeParameters)) {
            throw new UserRequestException("Nothing executable found in request.");
        }
    }

    @Override
    public void setReviewId(int reviewId) {
        this._reviewId = reviewId;
    }

    public Integer reviewId() {
        return this._reviewId;
    }

    public boolean dryRun() {
        return this._dryRun;
    }

    public boolean stopOngoingExecution() {
        return this._stopOngoingExecution;
    }

    public String reason() {
        return this._reason;
    }

    @Override
    public void configure(Map<String, ?> configs) {
        super.configure(configs);
        this._configs = configs;
    }

    public TopicReplicationFactorChangeParameters topicReplicationFactorChangeParameters() {
        return this._topicReplicationFactorChangeParameters;
    }

    public SortedSet<String> caseInsensitiveParameterNames() {
        return CASE_INSENSITIVE_PARAMETER_NAMES;
    }

    static {
        TreeSet<String> validParameterNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        validParameterNames.add("review_id");
        validParameterNames.add("dryrun");
        validParameterNames.add("stop_ongoing_execution");
        validParameterNames.add("reason");
        validParameterNames.addAll(TopicReplicationFactorChangeParameters.CASE_INSENSITIVE_PARAMETER_NAMES);
        validParameterNames.addAll(GoalBasedOptimizationParameters.CASE_INSENSITIVE_PARAMETER_NAMES);
        CASE_INSENSITIVE_PARAMETER_NAMES = Collections.unmodifiableSortedSet(validParameterNames);
    }

    public static enum TopicConfigurationType {
        REPLICATION_FACTOR;

    }
}

