/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.servlet.parameters;

import com.linkedin.kafka.cruisecontrol.executor.strategy.ReplicaMovementStrategy;
import com.linkedin.kafka.cruisecontrol.servlet.UserRequestException;
import com.linkedin.kafka.cruisecontrol.servlet.parameters.ParameterUtils;
import com.linkedin.kafka.cruisecontrol.servlet.parameters.ProposalsParameters;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public class RebalanceParameters
extends ProposalsParameters {
    protected static final SortedSet<String> CASE_INSENSITIVE_PARAMETER_NAMES;
    protected boolean _dryRun;
    protected Integer _concurrentInterBrokerPartitionMovements;
    protected Integer _concurrentIntraBrokerPartitionMovements;
    protected Integer _concurrentLeaderMovements;
    protected Long _executionProgressCheckIntervalMs;
    protected boolean _skipHardGoalCheck;
    protected ReplicaMovementStrategy _replicaMovementStrategy;
    protected Long _replicationThrottle;
    protected Integer _reviewId;
    protected String _reason;
    protected boolean _stopOngoingExecution;

    @Override
    protected void initParameters() throws UnsupportedEncodingException {
        super.initParameters();
        this._dryRun = ParameterUtils.getDryRun(this._request);
        this._concurrentInterBrokerPartitionMovements = ParameterUtils.concurrentMovements(this._request, true, false);
        this._concurrentIntraBrokerPartitionMovements = ParameterUtils.concurrentMovements(this._request, false, true);
        this._concurrentLeaderMovements = ParameterUtils.concurrentMovements(this._request, false, false);
        this._executionProgressCheckIntervalMs = ParameterUtils.executionProgressCheckIntervalMs(this._request);
        this._skipHardGoalCheck = ParameterUtils.skipHardGoalCheck(this._request);
        this._replicaMovementStrategy = ParameterUtils.getReplicaMovementStrategy(this._request, this._config);
        this._ignoreProposalCache = ParameterUtils.ignoreProposalCache(this._request);
        this._destinationBrokerIds = ParameterUtils.destinationBrokerIds(this._request);
        boolean twoStepVerificationEnabled = this._config.getBoolean("two.step.verification.enabled");
        this._replicationThrottle = ParameterUtils.replicationThrottle(this._request, this._config);
        this._reviewId = ParameterUtils.reviewId(this._request, twoStepVerificationEnabled);
        this._isRebalanceDiskMode = ParameterUtils.isRebalanceDiskMode(this._request);
        boolean requestReasonRequired = this._config.getBoolean("request.reason.required");
        this._reason = ParameterUtils.reason(this._request, requestReasonRequired && !this._dryRun);
        this._stopOngoingExecution = ParameterUtils.stopOngoingExecution(this._request);
        if (this._stopOngoingExecution && this._dryRun) {
            throw new UserRequestException(String.format("%s and %s cannot both be set to true.", "stop_ongoing_execution", "dryrun"));
        }
    }

    @Override
    public void setReviewId(int reviewId) {
        this._reviewId = reviewId;
    }

    public Integer reviewId() {
        return this._reviewId;
    }

    public boolean dryRun() {
        return this._dryRun;
    }

    public Integer concurrentInterBrokerPartitionMovements() {
        return this._concurrentInterBrokerPartitionMovements;
    }

    public Integer concurrentIntraBrokerPartitionMovements() {
        return this._concurrentIntraBrokerPartitionMovements;
    }

    public Long executionProgressCheckIntervalMs() {
        return this._executionProgressCheckIntervalMs;
    }

    public Integer concurrentLeaderMovements() {
        return this._concurrentLeaderMovements;
    }

    public boolean skipHardGoalCheck() {
        return this._skipHardGoalCheck;
    }

    public ReplicaMovementStrategy replicaMovementStrategy() {
        return this._replicaMovementStrategy;
    }

    public Long replicationThrottle() {
        return this._replicationThrottle;
    }

    public String reason() {
        return this._reason;
    }

    public boolean stopOngoingExecution() {
        return this._stopOngoingExecution;
    }

    @Override
    public void configure(Map<String, ?> configs) {
        super.configure(configs);
    }

    @Override
    public SortedSet<String> caseInsensitiveParameterNames() {
        return CASE_INSENSITIVE_PARAMETER_NAMES;
    }

    static {
        TreeSet<String> validParameterNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        validParameterNames.add("dryrun");
        validParameterNames.add("reason");
        validParameterNames.add("concurrent_partition_movements_per_broker");
        validParameterNames.add("concurrent_intra_broker_partition_movements");
        validParameterNames.add("concurrent_leader_movements");
        validParameterNames.add("execution_progress_check_interval_ms");
        validParameterNames.add("skip_hard_goal_check");
        validParameterNames.add("replica_movement_strategies");
        validParameterNames.add("replication_throttle");
        validParameterNames.add("review_id");
        validParameterNames.add("stop_ongoing_execution");
        validParameterNames.addAll(ProposalsParameters.CASE_INSENSITIVE_PARAMETER_NAMES);
        CASE_INSENSITIVE_PARAMETER_NAMES = Collections.unmodifiableSortedSet(validParameterNames);
    }
}

