/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.servlet.parameters;

import com.linkedin.kafka.cruisecontrol.servlet.parameters.GoalBasedOptimizationParameters;
import com.linkedin.kafka.cruisecontrol.servlet.parameters.ParameterUtils;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class ProposalsParameters
extends GoalBasedOptimizationParameters {
    protected static final SortedSet<String> CASE_INSENSITIVE_PARAMETER_NAMES;
    protected Set<Integer> _destinationBrokerIds;
    protected boolean _ignoreProposalCache;
    protected boolean _isRebalanceDiskMode;

    @Override
    protected void initParameters() throws UnsupportedEncodingException {
        super.initParameters();
        this._destinationBrokerIds = ParameterUtils.destinationBrokerIds(this._request);
        this._ignoreProposalCache = ParameterUtils.ignoreProposalCache(this._request);
        this._isRebalanceDiskMode = ParameterUtils.isRebalanceDiskMode(this._request);
    }

    public Set<Integer> destinationBrokerIds() {
        return this._destinationBrokerIds;
    }

    public boolean ignoreProposalCache() {
        return this._ignoreProposalCache;
    }

    public boolean isRebalanceDiskMode() {
        return this._isRebalanceDiskMode;
    }

    @Override
    public void configure(Map<String, ?> configs) {
        super.configure(configs);
    }

    public SortedSet<String> caseInsensitiveParameterNames() {
        return CASE_INSENSITIVE_PARAMETER_NAMES;
    }

    static {
        TreeSet<String> validParameterNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        validParameterNames.add("kafka_assigner");
        validParameterNames.add("destination_broker_ids");
        validParameterNames.add("ignore_proposal_cache");
        validParameterNames.add("rebalance_disk");
        validParameterNames.addAll(GoalBasedOptimizationParameters.CASE_INSENSITIVE_PARAMETER_NAMES);
        CASE_INSENSITIVE_PARAMETER_NAMES = Collections.unmodifiableSortedSet(validParameterNames);
    }
}

