/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.servlet.parameters;

import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.servlet.UserRequestException;
import com.linkedin.kafka.cruisecontrol.servlet.parameters.AbstractParameters;
import com.linkedin.kafka.cruisecontrol.servlet.parameters.ParameterUtils;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;

public class PartitionLoadParameters
extends AbstractParameters {
    protected static final SortedSet<String> CASE_INSENSITIVE_PARAMETER_NAMES;
    protected Resource _resource;
    protected long _startMs;
    protected long _endMs;
    protected int _entries;
    protected Pattern _topic;
    protected int _partitionUpperBoundary;
    protected int _partitionLowerBoundary;
    protected Double _minValidPartitionRatio;
    protected boolean _allowCapacityEstimation;
    protected boolean _wantMaxLoad;
    protected boolean _wantAvgLoad;
    protected Set<Integer> _brokerIds;

    @Override
    protected void initParameters() throws UnsupportedEncodingException {
        super.initParameters();
        String resourceString = ParameterUtils.resourceString(this._request);
        try {
            this._resource = Resource.valueOf(resourceString.toUpperCase());
        }
        catch (IllegalArgumentException iae) {
            throw new UserRequestException(String.format("Invalid resource type %s. The resource type must be one of the following: CPU, DISK, NW_IN, NW_OUT", resourceString));
        }
        this._wantMaxLoad = ParameterUtils.wantMaxLoad(this._request);
        this._wantAvgLoad = ParameterUtils.wantAvgLoad(this._request);
        if (this._wantMaxLoad && this._wantAvgLoad) {
            throw new UserRequestException("Parameters to ask for max and avg load are mutually exclusive to each other.");
        }
        this._topic = ParameterUtils.topic(this._request);
        this._partitionLowerBoundary = ParameterUtils.partitionBoundary(this._request, false);
        this._partitionUpperBoundary = ParameterUtils.partitionBoundary(this._request, true);
        this._entries = ParameterUtils.entries(this._request);
        this._minValidPartitionRatio = ParameterUtils.minValidPartitionRatio(this._request);
        this._allowCapacityEstimation = ParameterUtils.allowCapacityEstimation(this._request);
        this._brokerIds = ParameterUtils.brokerIds(this._request, true);
        this._startMs = ParameterUtils.startMsOrDefault(this._request, -1L);
        this._endMs = ParameterUtils.endMsOrDefault(this._request, System.currentTimeMillis());
        ParameterUtils.validateTimeRange(this._startMs, this._endMs);
    }

    public Resource resource() {
        return this._resource;
    }

    public long startMs() {
        return this._startMs;
    }

    public long endMs() {
        return this._endMs;
    }

    public int entries() {
        return this._entries;
    }

    public Pattern topic() {
        return this._topic;
    }

    public int partitionUpperBoundary() {
        return this._partitionUpperBoundary;
    }

    public int partitionLowerBoundary() {
        return this._partitionLowerBoundary;
    }

    public Double minValidPartitionRatio() {
        return this._minValidPartitionRatio;
    }

    public boolean allowCapacityEstimation() {
        return this._allowCapacityEstimation;
    }

    public boolean wantMaxLoad() {
        return this._wantMaxLoad;
    }

    public boolean wantAvgLoad() {
        return this._wantAvgLoad;
    }

    public Set<Integer> brokerIds() {
        return this._brokerIds;
    }

    @Override
    public void configure(Map<String, ?> configs) {
        super.configure(configs);
    }

    public SortedSet<String> caseInsensitiveParameterNames() {
        return CASE_INSENSITIVE_PARAMETER_NAMES;
    }

    static {
        TreeSet<String> validParameterNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        validParameterNames.add("resource");
        validParameterNames.add("start");
        validParameterNames.add("end");
        validParameterNames.add("entries");
        validParameterNames.add("topic");
        validParameterNames.add("partition");
        validParameterNames.add("min_valid_partition_ratio");
        validParameterNames.add("allow_capacity_estimation");
        validParameterNames.add("max_load");
        validParameterNames.add("avg_load");
        validParameterNames.add("brokerid");
        validParameterNames.addAll(AbstractParameters.CASE_INSENSITIVE_PARAMETER_NAMES);
        CASE_INSENSITIVE_PARAMETER_NAMES = Collections.unmodifiableSortedSet(validParameterNames);
    }
}

