/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.servlet.parameters;

import com.linkedin.kafka.cruisecontrol.servlet.parameters.AbstractParameters;
import com.linkedin.kafka.cruisecontrol.servlet.parameters.ParameterUtils;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public abstract class KafkaOptimizationParameters
extends AbstractParameters {
    protected static final SortedSet<String> CASE_INSENSITIVE_PARAMETER_NAMES;
    protected boolean _allowCapacityEstimation;
    protected boolean _isVerbose;
    protected boolean _excludeRecentlyDemotedBrokers;

    KafkaOptimizationParameters() {
    }

    @Override
    protected void initParameters() throws UnsupportedEncodingException {
        super.initParameters();
        this._allowCapacityEstimation = ParameterUtils.allowCapacityEstimation(this._request);
        this._isVerbose = ParameterUtils.isVerbose(this._request);
        this._excludeRecentlyDemotedBrokers = ParameterUtils.excludeRecentlyDemotedBrokers(this._request);
    }

    public boolean allowCapacityEstimation() {
        return this._allowCapacityEstimation;
    }

    public boolean isVerbose() {
        return this._isVerbose;
    }

    public boolean excludeRecentlyDemotedBrokers() {
        return this._excludeRecentlyDemotedBrokers;
    }

    @Override
    public void configure(Map<String, ?> configs) {
        super.configure(configs);
    }

    static {
        TreeSet<String> validParameterNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        validParameterNames.add("allow_capacity_estimation");
        validParameterNames.add("verbose");
        validParameterNames.add("exclude_recently_demoted_brokers");
        validParameterNames.addAll(AbstractParameters.CASE_INSENSITIVE_PARAMETER_NAMES);
        CASE_INSENSITIVE_PARAMETER_NAMES = Collections.unmodifiableSortedSet(validParameterNames);
    }
}

