/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.servlet.parameters;

import com.linkedin.kafka.cruisecontrol.monitor.ModelCompletenessRequirements;
import com.linkedin.kafka.cruisecontrol.servlet.parameters.GoalsAndRequirements;
import com.linkedin.kafka.cruisecontrol.servlet.parameters.KafkaOptimizationParameters;
import com.linkedin.kafka.cruisecontrol.servlet.parameters.ParameterUtils;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;

public abstract class GoalBasedOptimizationParameters
extends KafkaOptimizationParameters {
    protected static final SortedSet<String> CASE_INSENSITIVE_PARAMETER_NAMES;
    private static final boolean INCLUDE_ALL_TOPICS = true;
    private static final Map<ParameterUtils.DataFrom, Integer> MIN_NUM_VALID_WINDOWS;
    private static final Map<ParameterUtils.DataFrom, Double> MIN_VALID_PARTITIONS_RATIO;
    protected ParameterUtils.DataFrom _dataFrom;
    protected boolean _useReadyDefaultGoals;
    protected Pattern _excludedTopics;
    protected boolean _excludeRecentlyRemovedBrokers;
    protected GoalsAndRequirements _goalsAndRequirements;

    GoalBasedOptimizationParameters() {
    }

    @Override
    protected void initParameters() throws UnsupportedEncodingException {
        super.initParameters();
        this._dataFrom = ParameterUtils.getDataFrom(this._request);
        this._useReadyDefaultGoals = ParameterUtils.useReadyDefaultGoals(this._request);
        this._excludedTopics = ParameterUtils.excludedTopics(this._request);
        this._excludeRecentlyRemovedBrokers = ParameterUtils.excludeRecentlyRemovedBrokers(this._request);
        List<String> goals = ParameterUtils.getGoals(this._request);
        this._goalsAndRequirements = new GoalsAndRequirements(goals, GoalBasedOptimizationParameters.getRequirements(this._dataFrom));
    }

    public ParameterUtils.DataFrom dataFrom() {
        return this._dataFrom;
    }

    public boolean useReadyDefaultGoals() {
        return this._useReadyDefaultGoals;
    }

    public List<String> goals() {
        return this._goalsAndRequirements.goals();
    }

    public ModelCompletenessRequirements modelCompletenessRequirements() {
        return this._goalsAndRequirements.requirements();
    }

    public Pattern excludedTopics() {
        return this._excludedTopics;
    }

    public boolean excludeRecentlyRemovedBrokers() {
        return this._excludeRecentlyRemovedBrokers;
    }

    protected static ModelCompletenessRequirements getRequirements(ParameterUtils.DataFrom dataFrom) {
        return new ModelCompletenessRequirements(MIN_NUM_VALID_WINDOWS.get((Object)dataFrom), MIN_VALID_PARTITIONS_RATIO.get((Object)dataFrom), true);
    }

    @Override
    public void configure(Map<String, ?> configs) {
        super.configure(configs);
    }

    static {
        TreeSet<String> validParameterNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        validParameterNames.add("data_from");
        validParameterNames.add("use_ready_default_goals");
        validParameterNames.add("excluded_topics");
        validParameterNames.add("exclude_recently_removed_brokers");
        validParameterNames.add("goals");
        validParameterNames.addAll(KafkaOptimizationParameters.CASE_INSENSITIVE_PARAMETER_NAMES);
        CASE_INSENSITIVE_PARAMETER_NAMES = Collections.unmodifiableSortedSet(validParameterNames);
        MIN_NUM_VALID_WINDOWS = new HashMap<ParameterUtils.DataFrom, Integer>(2);
        MIN_VALID_PARTITIONS_RATIO = new HashMap<ParameterUtils.DataFrom, Double>(2);
        MIN_NUM_VALID_WINDOWS.put(ParameterUtils.DataFrom.VALID_PARTITIONS, Integer.MAX_VALUE);
        MIN_NUM_VALID_WINDOWS.put(ParameterUtils.DataFrom.VALID_WINDOWS, 1);
        MIN_VALID_PARTITIONS_RATIO.put(ParameterUtils.DataFrom.VALID_PARTITIONS, 0.0);
        MIN_VALID_PARTITIONS_RATIO.put(ParameterUtils.DataFrom.VALID_WINDOWS, 1.0);
    }
}

