/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.servlet.parameters;

import com.linkedin.kafka.cruisecontrol.executor.strategy.ReplicaMovementStrategy;
import com.linkedin.kafka.cruisecontrol.servlet.UserRequestException;
import com.linkedin.kafka.cruisecontrol.servlet.parameters.KafkaOptimizationParameters;
import com.linkedin.kafka.cruisecontrol.servlet.parameters.ParameterUtils;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class DemoteBrokerParameters
extends KafkaOptimizationParameters {
    protected static final SortedSet<String> CASE_INSENSITIVE_PARAMETER_NAMES;
    protected boolean _dryRun;
    protected Set<Integer> _brokerIds;
    protected Integer _concurrentLeaderMovements;
    protected Long _executionProgressCheckIntervalMs;
    protected boolean _skipUrpDemotion;
    protected boolean _excludeFollowerDemotion;
    protected ReplicaMovementStrategy _replicaMovementStrategy;
    protected Long _replicationThrottle;
    protected Integer _reviewId;
    protected Map<Integer, Set<String>> _logdirByBrokerId;
    protected String _reason;
    protected boolean _stopOngoingExecution;

    @Override
    protected void initParameters() throws UnsupportedEncodingException {
        super.initParameters();
        this._brokerIds = ParameterUtils.brokerIds(this._request, false);
        this._dryRun = ParameterUtils.getDryRun(this._request);
        this._concurrentLeaderMovements = ParameterUtils.concurrentMovements(this._request, false, false);
        this._executionProgressCheckIntervalMs = ParameterUtils.executionProgressCheckIntervalMs(this._request);
        this._allowCapacityEstimation = ParameterUtils.allowCapacityEstimation(this._request);
        this._skipUrpDemotion = ParameterUtils.skipUrpDemotion(this._request);
        this._excludeFollowerDemotion = ParameterUtils.excludeFollowerDemotion(this._request);
        this._replicaMovementStrategy = ParameterUtils.getReplicaMovementStrategy(this._request, this._config);
        this._replicationThrottle = ParameterUtils.replicationThrottle(this._request, this._config);
        boolean twoStepVerificationEnabled = this._config.getBoolean("two.step.verification.enabled");
        this._reviewId = ParameterUtils.reviewId(this._request, twoStepVerificationEnabled);
        this._logdirByBrokerId = ParameterUtils.brokerIdAndLogdirs(this._request);
        boolean requestReasonRequired = this._config.getBoolean("request.reason.required");
        this._reason = ParameterUtils.reason(this._request, requestReasonRequired && !this._dryRun);
        this._stopOngoingExecution = ParameterUtils.stopOngoingExecution(this._request);
        if (this._stopOngoingExecution && this._dryRun) {
            throw new UserRequestException(String.format("%s and %s cannot both be set to true.", "stop_ongoing_execution", "dryrun"));
        }
    }

    @Override
    public void setReviewId(int reviewId) {
        this._reviewId = reviewId;
    }

    public Integer reviewId() {
        return this._reviewId;
    }

    public boolean dryRun() {
        return this._dryRun;
    }

    public Set<Integer> brokerIds() {
        return this._brokerIds;
    }

    public Integer concurrentLeaderMovements() {
        return this._concurrentLeaderMovements;
    }

    public Long executionProgressCheckIntervalMs() {
        return this._executionProgressCheckIntervalMs;
    }

    public boolean skipUrpDemotion() {
        return this._skipUrpDemotion;
    }

    public boolean excludeFollowerDemotion() {
        return this._excludeFollowerDemotion;
    }

    public Map<Integer, Set<String>> brokerIdAndLogdirs() {
        return this._logdirByBrokerId;
    }

    public ReplicaMovementStrategy replicaMovementStrategy() {
        return this._replicaMovementStrategy;
    }

    public Long replicationThrottle() {
        return this._replicationThrottle;
    }

    public String reason() {
        return this._reason;
    }

    public boolean stopOngoingExecution() {
        return this._stopOngoingExecution;
    }

    @Override
    public void configure(Map<String, ?> configs) {
        super.configure(configs);
    }

    public SortedSet<String> caseInsensitiveParameterNames() {
        return CASE_INSENSITIVE_PARAMETER_NAMES;
    }

    static {
        TreeSet<String> validParameterNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        validParameterNames.add("dryrun");
        validParameterNames.add("reason");
        validParameterNames.add("brokerid");
        validParameterNames.add("concurrent_leader_movements");
        validParameterNames.add("execution_progress_check_interval_ms");
        validParameterNames.add("skip_urp_demotion");
        validParameterNames.add("exclude_follower_demotion");
        validParameterNames.add("replica_movement_strategies");
        validParameterNames.add("replication_throttle");
        validParameterNames.add("review_id");
        validParameterNames.add("brokerid_and_logdirs");
        validParameterNames.add("stop_ongoing_execution");
        validParameterNames.addAll(KafkaOptimizationParameters.CASE_INSENSITIVE_PARAMETER_NAMES);
        CASE_INSENSITIVE_PARAMETER_NAMES = Collections.unmodifiableSortedSet(validParameterNames);
    }
}

