/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.servlet.parameters;

import com.linkedin.kafka.cruisecontrol.monitor.ModelCompletenessRequirements;
import com.linkedin.kafka.cruisecontrol.servlet.parameters.AbstractParameters;
import com.linkedin.kafka.cruisecontrol.servlet.parameters.ParameterUtils;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public class ClusterLoadParameters
extends AbstractParameters {
    protected static final SortedSet<String> CASE_INSENSITIVE_PARAMETER_NAMES;
    protected long _endMs;
    protected long _startMs;
    protected ModelCompletenessRequirements _requirements;
    protected boolean _allowCapacityEstimation;
    protected boolean _populateDiskInfo;
    protected boolean _capacityOnly;

    @Override
    protected void initParameters() throws UnsupportedEncodingException {
        super.initParameters();
        Long time = ParameterUtils.time(this._request);
        this._endMs = time == null ? ParameterUtils.endMsOrDefault(this._request, System.currentTimeMillis()) : time;
        this._startMs = ParameterUtils.startMsOrDefault(this._request, -1L);
        ParameterUtils.validateTimeRange(this._startMs, this._endMs);
        this._requirements = new ModelCompletenessRequirements(1, 0.0, true);
        this._allowCapacityEstimation = ParameterUtils.allowCapacityEstimation(this._request);
        this._populateDiskInfo = ParameterUtils.populateDiskInfo(this._request);
        this._capacityOnly = ParameterUtils.capacityOnly(this._request);
    }

    public long startMs() {
        return this._startMs;
    }

    public long endMs() {
        return this._endMs;
    }

    public ModelCompletenessRequirements requirements() {
        return this._requirements;
    }

    public boolean allowCapacityEstimation() {
        return this._allowCapacityEstimation;
    }

    public boolean populateDiskInfo() {
        return this._populateDiskInfo;
    }

    public boolean capacityOnly() {
        return this._capacityOnly;
    }

    @Override
    public void configure(Map<String, ?> configs) {
        super.configure(configs);
    }

    public SortedSet<String> caseInsensitiveParameterNames() {
        return CASE_INSENSITIVE_PARAMETER_NAMES;
    }

    static {
        TreeSet<String> validParameterNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        validParameterNames.add("time");
        validParameterNames.add("end");
        validParameterNames.add("start");
        validParameterNames.add("allow_capacity_estimation");
        validParameterNames.add("populate_disk_info");
        validParameterNames.add("capacity_only");
        validParameterNames.addAll(AbstractParameters.CASE_INSENSITIVE_PARAMETER_NAMES);
        CASE_INSENSITIVE_PARAMETER_NAMES = Collections.unmodifiableSortedSet(validParameterNames);
    }
}

