/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.servlet.parameters;

import com.linkedin.kafka.cruisecontrol.servlet.parameters.AbstractParameters;
import com.linkedin.kafka.cruisecontrol.servlet.parameters.ParameterUtils;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public class ChangeExecutionConcurrencyParameters
extends AbstractParameters {
    protected static final SortedSet<String> CASE_INSENSITIVE_PARAMETER_NAMES;
    protected Long _executionProgressCheckIntervalMs;
    protected Integer _concurrentInterBrokerPartitionMovements;
    protected Integer _concurrentIntraBrokerPartitionMovements;
    protected Integer _concurrentLeaderMovements;

    protected ChangeExecutionConcurrencyParameters() {
    }

    @Override
    protected void initParameters() throws UnsupportedEncodingException {
        super.initParameters();
        this._executionProgressCheckIntervalMs = ParameterUtils.executionProgressCheckIntervalMs(this._request);
        this._concurrentInterBrokerPartitionMovements = ParameterUtils.concurrentMovements(this._request, true, false);
        this._concurrentIntraBrokerPartitionMovements = ParameterUtils.concurrentMovements(this._request, false, true);
        this._concurrentLeaderMovements = ParameterUtils.concurrentMovements(this._request, false, false);
    }

    public static ChangeExecutionConcurrencyParameters maybeBuildChangeExecutionConcurrencyParameters(Map<String, ?> configs) throws UnsupportedEncodingException {
        ChangeExecutionConcurrencyParameters changeExecutionConcurrencyParameters = new ChangeExecutionConcurrencyParameters();
        changeExecutionConcurrencyParameters.configure(configs);
        changeExecutionConcurrencyParameters.initParameters();
        if (changeExecutionConcurrencyParameters.executionProgressCheckIntervalMs() == null && changeExecutionConcurrencyParameters.concurrentInterBrokerPartitionMovements() == null && changeExecutionConcurrencyParameters.concurrentIntraBrokerPartitionMovements() == null && changeExecutionConcurrencyParameters.concurrentLeaderMovements() == null) {
            return null;
        }
        return changeExecutionConcurrencyParameters;
    }

    public Long executionProgressCheckIntervalMs() {
        return this._executionProgressCheckIntervalMs;
    }

    public Integer concurrentInterBrokerPartitionMovements() {
        return this._concurrentInterBrokerPartitionMovements;
    }

    public Integer concurrentIntraBrokerPartitionMovements() {
        return this._concurrentIntraBrokerPartitionMovements;
    }

    public Integer concurrentLeaderMovements() {
        return this._concurrentLeaderMovements;
    }

    public SortedSet<String> caseInsensitiveParameterNames() {
        return CASE_INSENSITIVE_PARAMETER_NAMES;
    }

    static {
        TreeSet<String> validParameterNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        validParameterNames.add("execution_progress_check_interval_ms");
        validParameterNames.add("concurrent_partition_movements_per_broker");
        validParameterNames.add("concurrent_intra_broker_partition_movements");
        validParameterNames.add("concurrent_leader_movements");
        validParameterNames.addAll(AbstractParameters.CASE_INSENSITIVE_PARAMETER_NAMES);
        CASE_INSENSITIVE_PARAMETER_NAMES = Collections.unmodifiableSortedSet(validParameterNames);
    }
}

