/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.servlet.parameters;

import com.linkedin.kafka.cruisecontrol.servlet.UserRequestException;
import com.linkedin.kafka.cruisecontrol.servlet.parameters.AbstractParameters;
import com.linkedin.kafka.cruisecontrol.servlet.parameters.ChangeExecutionConcurrencyParameters;
import com.linkedin.kafka.cruisecontrol.servlet.parameters.DropRecentBrokersParameters;
import com.linkedin.kafka.cruisecontrol.servlet.parameters.ParameterUtils;
import com.linkedin.kafka.cruisecontrol.servlet.parameters.UpdateConcurrencyAdjusterParameters;
import com.linkedin.kafka.cruisecontrol.servlet.parameters.UpdateSelfHealingParameters;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public class AdminParameters
extends AbstractParameters {
    protected static final SortedSet<String> CASE_INSENSITIVE_PARAMETER_NAMES;
    protected Integer _reviewId;
    protected Map<String, ?> _configs;
    protected DropRecentBrokersParameters _dropBrokersParameters;
    protected UpdateSelfHealingParameters _updateSelfHealingParameters;
    protected ChangeExecutionConcurrencyParameters _changeExecutionConcurrencyParameters;
    protected UpdateConcurrencyAdjusterParameters _updateConcurrencyAdjusterParameters;

    @Override
    protected void initParameters() throws UnsupportedEncodingException {
        super.initParameters();
        boolean twoStepVerificationEnabled = this._config.getBoolean("two.step.verification.enabled");
        this._reviewId = ParameterUtils.reviewId(this._request, twoStepVerificationEnabled);
        this._dropBrokersParameters = DropRecentBrokersParameters.maybeBuildDropRecentBrokersParameters(this._configs);
        this._updateSelfHealingParameters = UpdateSelfHealingParameters.maybeBuildUpdateSelfHealingParameters(this._configs);
        this._changeExecutionConcurrencyParameters = ChangeExecutionConcurrencyParameters.maybeBuildChangeExecutionConcurrencyParameters(this._configs);
        this._updateConcurrencyAdjusterParameters = UpdateConcurrencyAdjusterParameters.maybeBuildUpdateConcurrencyAdjusterParameters(this._configs);
        if (ParameterUtils.areAllParametersNull(this._dropBrokersParameters, this._updateSelfHealingParameters, this._changeExecutionConcurrencyParameters, this._updateConcurrencyAdjusterParameters)) {
            throw new UserRequestException("Nothing executable found in request.");
        }
    }

    @Override
    public void setReviewId(int reviewId) {
        this._reviewId = reviewId;
    }

    public Integer reviewId() {
        return this._reviewId;
    }

    public DropRecentBrokersParameters dropRecentBrokersParameters() {
        return this._dropBrokersParameters;
    }

    public UpdateSelfHealingParameters updateSelfHealingParameters() {
        return this._updateSelfHealingParameters;
    }

    public ChangeExecutionConcurrencyParameters changeExecutionConcurrencyParameters() {
        return this._changeExecutionConcurrencyParameters;
    }

    public UpdateConcurrencyAdjusterParameters updateConcurrencyAdjusterParameters() {
        return this._updateConcurrencyAdjusterParameters;
    }

    @Override
    public void configure(Map<String, ?> configs) {
        super.configure(configs);
        this._configs = configs;
    }

    public SortedSet<String> caseInsensitiveParameterNames() {
        return CASE_INSENSITIVE_PARAMETER_NAMES;
    }

    static {
        TreeSet<String> validParameterNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        validParameterNames.add("review_id");
        validParameterNames.addAll(DropRecentBrokersParameters.CASE_INSENSITIVE_PARAMETER_NAMES);
        validParameterNames.addAll(UpdateSelfHealingParameters.CASE_INSENSITIVE_PARAMETER_NAMES);
        validParameterNames.addAll(ChangeExecutionConcurrencyParameters.CASE_INSENSITIVE_PARAMETER_NAMES);
        validParameterNames.addAll(UpdateConcurrencyAdjusterParameters.CASE_INSENSITIVE_PARAMETER_NAMES);
        validParameterNames.addAll(AbstractParameters.CASE_INSENSITIVE_PARAMETER_NAMES);
        CASE_INSENSITIVE_PARAMETER_NAMES = Collections.unmodifiableSortedSet(validParameterNames);
    }

    public static enum AdminType {
        UPDATE_SELF_HEALING,
        CHANGE_CONCURRENCY,
        DROP_RECENT_BROKERS,
        UPDATE_CONCURRENCY_ADJUSTER;

    }
}

