/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.servlet.parameters;

import com.linkedin.cruisecontrol.servlet.EndPoint;
import com.linkedin.cruisecontrol.servlet.parameters.CruiseControlParameters;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.servlet.parameters.ParameterUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractParameters
implements CruiseControlParameters {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractParameters.class);
    protected static final SortedSet<String> CASE_INSENSITIVE_PARAMETER_NAMES;
    protected HttpServletRequest _request;
    protected boolean _initialized = false;
    protected KafkaCruiseControlConfig _config;
    protected boolean _json = false;
    protected boolean _wantResponseSchema = false;
    protected EndPoint _endPoint = null;

    protected void initParameters() throws UnsupportedEncodingException {
        this._initialized = true;
        this._endPoint = ParameterUtils.endPoint(this._request);
        this._json = ParameterUtils.wantJSON(this._request);
        this._wantResponseSchema = ParameterUtils.wantResponseSchema(this._request);
    }

    public boolean parseParameters(HttpServletResponse response) {
        if (this._initialized) {
            LOG.trace("Attempt to parse an already parsed request {}.", (Object)this._request);
            return false;
        }
        try {
            this.initParameters();
            return false;
        }
        catch (Exception e) {
            try {
                ParameterUtils.handleParameterParseException(e, response, e.getMessage(), this._json, this._wantResponseSchema, this._config);
            }
            catch (IOException ioe) {
                LOG.error(String.format("Failed to write parse parameter exception to output stream. Endpoint: %s.", this._endPoint), (Throwable)ioe);
            }
            return true;
        }
    }

    public boolean json() {
        return this._json;
    }

    public boolean wantResponseSchema() {
        return this._wantResponseSchema;
    }

    public void setReviewId(int reviewId) {
    }

    public EndPoint endPoint() {
        return this._endPoint;
    }

    public void configure(Map<String, ?> configs) {
        this._request = (HttpServletRequest)configs.get("kafka.cruise.control.http.servlet.request.object");
        if (this._request == null) {
            throw new IllegalArgumentException("HttpServletRequest configuration is missing from the request.");
        }
        this._config = (KafkaCruiseControlConfig)((Object)configs.get("kafka.cruise.control.config.object"));
        if (this._config == null) {
            throw new IllegalArgumentException("KafkaCruiseControlConfig configuration is missing from the request.");
        }
    }

    static {
        TreeSet<String> validParameterNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        validParameterNames.add("json");
        validParameterNames.add("get_response_schema");
        validParameterNames.add("doAs");
        CASE_INSENSITIVE_PARAMETER_NAMES = Collections.unmodifiableSortedSet(validParameterNames);
    }
}

