/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.servlet.handler.sync;

import com.linkedin.kafka.cruisecontrol.KafkaCruiseControl;
import com.linkedin.kafka.cruisecontrol.servlet.handler.sync.AbstractSyncRequest;
import com.linkedin.kafka.cruisecontrol.servlet.parameters.BootstrapParameters;
import com.linkedin.kafka.cruisecontrol.servlet.response.BootstrapResult;
import java.util.Map;

public class BootstrapRequest
extends AbstractSyncRequest {
    protected KafkaCruiseControl _kafkaCruiseControl;
    protected BootstrapParameters _parameters;

    @Override
    protected BootstrapResult handle() {
        Long startMs = this._parameters.startMs();
        Long endMs = this._parameters.endMs();
        boolean clearMetrics = this._parameters.clearMetrics();
        this._kafkaCruiseControl.bootstrap(startMs, endMs, clearMetrics);
        return new BootstrapResult(this._kafkaCruiseControl.config());
    }

    @Override
    public BootstrapParameters parameters() {
        return this._parameters;
    }

    @Override
    public String name() {
        return BootstrapRequest.class.getSimpleName();
    }

    @Override
    public void configure(Map<String, ?> configs) {
        super.configure(configs);
        this._kafkaCruiseControl = this._servlet.asyncKafkaCruiseControl();
        this._parameters = (BootstrapParameters)configs.get("bootstrap.parameter.object");
        if (this._parameters == null) {
            throw new IllegalArgumentException("Parameter configuration is missing from the request.");
        }
    }
}

