/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.servlet.handler.sync;

import com.linkedin.cruisecontrol.detector.AnomalyType;
import com.linkedin.kafka.cruisecontrol.KafkaCruiseControl;
import com.linkedin.kafka.cruisecontrol.detector.notifier.KafkaAnomalyType;
import com.linkedin.kafka.cruisecontrol.executor.ConcurrencyType;
import com.linkedin.kafka.cruisecontrol.servlet.handler.sync.AbstractSyncRequest;
import com.linkedin.kafka.cruisecontrol.servlet.parameters.AdminParameters;
import com.linkedin.kafka.cruisecontrol.servlet.parameters.ChangeExecutionConcurrencyParameters;
import com.linkedin.kafka.cruisecontrol.servlet.parameters.DropRecentBrokersParameters;
import com.linkedin.kafka.cruisecontrol.servlet.parameters.UpdateConcurrencyAdjusterParameters;
import com.linkedin.kafka.cruisecontrol.servlet.parameters.UpdateSelfHealingParameters;
import com.linkedin.kafka.cruisecontrol.servlet.response.AdminResult;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminRequest
extends AbstractSyncRequest {
    private static final Logger LOG = LoggerFactory.getLogger(AdminRequest.class);
    protected KafkaCruiseControl _kafkaCruiseControl;
    protected AdminParameters _parameters;

    @Override
    protected AdminResult handle() {
        String ongoingConcurrencyChangeRequest = this.processChangeExecutionConcurrencyRequest();
        HashMap<AnomalyType, Boolean> selfHealingBefore = new HashMap<AnomalyType, Boolean>(KafkaAnomalyType.cachedValues().size());
        HashMap<AnomalyType, Boolean> selfHealingAfter = new HashMap<AnomalyType, Boolean>(KafkaAnomalyType.cachedValues().size());
        this.processUpdateSelfHealingRequest(selfHealingBefore, selfHealingAfter);
        String dropRecentBrokersRequest = this.processDropRecentBrokersRequest();
        HashMap<ConcurrencyType, Boolean> concurrencyAdjusterBefore = new HashMap<ConcurrencyType, Boolean>(ConcurrencyType.cachedValues().size());
        HashMap<ConcurrencyType, Boolean> concurrencyAdjusterAfter = new HashMap<ConcurrencyType, Boolean>(ConcurrencyType.cachedValues().size());
        this.processUpdateConcurrencyAdjusterRequest(concurrencyAdjusterBefore, concurrencyAdjusterAfter);
        return new AdminResult(selfHealingBefore, selfHealingAfter, ongoingConcurrencyChangeRequest, dropRecentBrokersRequest, concurrencyAdjusterBefore, concurrencyAdjusterAfter, this._kafkaCruiseControl.config());
    }

    protected void processUpdateConcurrencyAdjusterRequest(Map<ConcurrencyType, Boolean> concurrencyAdjusterBefore, Map<ConcurrencyType, Boolean> concurrencyAdjusterAfter) {
        UpdateConcurrencyAdjusterParameters updateConcurrencyAdjusterParameters = this._parameters.updateConcurrencyAdjusterParameters();
        if (updateConcurrencyAdjusterParameters != null) {
            Set<ConcurrencyType> disableConcurrencyAdjusterFor = updateConcurrencyAdjusterParameters.disableConcurrencyAdjusterFor();
            Set<ConcurrencyType> enableConcurrencyAdjusterFor = updateConcurrencyAdjusterParameters.enableConcurrencyAdjusterFor();
            for (ConcurrencyType type : disableConcurrencyAdjusterFor) {
                concurrencyAdjusterBefore.put(type, this._kafkaCruiseControl.setConcurrencyAdjusterFor(type, false));
                concurrencyAdjusterAfter.put(type, false);
            }
            for (ConcurrencyType adjusterType : enableConcurrencyAdjusterFor) {
                concurrencyAdjusterBefore.put(adjusterType, this._kafkaCruiseControl.setConcurrencyAdjusterFor(adjusterType, true));
                concurrencyAdjusterAfter.put(adjusterType, true);
            }
            if (!disableConcurrencyAdjusterFor.isEmpty() || !enableConcurrencyAdjusterFor.isEmpty()) {
                LOG.info("Concurrency adjuster state is modified by user (before: {} after: {}).", concurrencyAdjusterBefore, concurrencyAdjusterAfter);
            }
        }
    }

    protected String processChangeExecutionConcurrencyRequest() {
        Long executionProgressCheckIntervalMs;
        Integer concurrentLeaderMovements;
        Integer concurrentIntraBrokerPartitionMovements;
        ChangeExecutionConcurrencyParameters changeExecutionConcurrencyParameters = this._parameters.changeExecutionConcurrencyParameters();
        if (changeExecutionConcurrencyParameters == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Integer concurrentInterBrokerPartitionMovements = changeExecutionConcurrencyParameters.concurrentInterBrokerPartitionMovements();
        if (concurrentInterBrokerPartitionMovements != null) {
            this._kafkaCruiseControl.setRequestedInterBrokerPartitionMovementConcurrency(concurrentInterBrokerPartitionMovements);
            sb.append(String.format("Inter-broker partition movement concurrency is set to %d%n", concurrentInterBrokerPartitionMovements));
            LOG.info("Inter-broker partition movement concurrency is set to: {} by user.", (Object)concurrentInterBrokerPartitionMovements);
        }
        if ((concurrentIntraBrokerPartitionMovements = changeExecutionConcurrencyParameters.concurrentIntraBrokerPartitionMovements()) != null) {
            this._kafkaCruiseControl.setRequestedIntraBrokerPartitionMovementConcurrency(concurrentIntraBrokerPartitionMovements);
            sb.append(String.format("Intra-broker partition movement concurrency is set to %d%n", concurrentIntraBrokerPartitionMovements));
            LOG.info("Intra-broker partition movement concurrency is set to: {} by user.", (Object)concurrentIntraBrokerPartitionMovements);
        }
        if ((concurrentLeaderMovements = changeExecutionConcurrencyParameters.concurrentLeaderMovements()) != null) {
            this._kafkaCruiseControl.setRequestedLeadershipMovementConcurrency(concurrentLeaderMovements);
            sb.append(String.format("Leadership movement concurrency is set to %d%n", concurrentLeaderMovements));
            LOG.info("Leadership movement concurrency is set to: {} by user.", (Object)concurrentLeaderMovements);
        }
        if ((executionProgressCheckIntervalMs = changeExecutionConcurrencyParameters.executionProgressCheckIntervalMs()) != null) {
            this._kafkaCruiseControl.setRequestedExecutionProgressCheckIntervalMs(executionProgressCheckIntervalMs);
            sb.append(String.format("Execution progress check interval is set to %dMs%n", executionProgressCheckIntervalMs));
            LOG.info("Execution progress check interval is set to: {}Ms by user.", (Object)executionProgressCheckIntervalMs);
        }
        return sb.toString();
    }

    protected void processUpdateSelfHealingRequest(Map<AnomalyType, Boolean> selfHealingBefore, Map<AnomalyType, Boolean> selfHealingAfter) {
        UpdateSelfHealingParameters updateSelfHealingParameters = this._parameters.updateSelfHealingParameters();
        if (updateSelfHealingParameters != null) {
            Set<AnomalyType> disableSelfHealingFor = updateSelfHealingParameters.disableSelfHealingFor();
            Set<AnomalyType> enableSelfHealingFor = updateSelfHealingParameters.enableSelfHealingFor();
            for (AnomalyType anomalyType : disableSelfHealingFor) {
                selfHealingBefore.put(anomalyType, this._kafkaCruiseControl.setSelfHealingFor(anomalyType, false));
                selfHealingAfter.put(anomalyType, false);
            }
            for (AnomalyType anomalyType : enableSelfHealingFor) {
                selfHealingBefore.put(anomalyType, this._kafkaCruiseControl.setSelfHealingFor(anomalyType, true));
                selfHealingAfter.put(anomalyType, true);
            }
            if (!disableSelfHealingFor.isEmpty() || !enableSelfHealingFor.isEmpty()) {
                LOG.info("Self healing state is modified by user (before: {} after: {}).", selfHealingBefore, selfHealingAfter);
            }
        }
    }

    protected String processDropRecentBrokersRequest() {
        Set<Integer> brokersToDropFromRecentlyDemoted;
        DropRecentBrokersParameters dropRecentBrokersParameters = this._parameters.dropRecentBrokersParameters();
        if (dropRecentBrokersParameters == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Set<Integer> brokersToDropFromRecentlyRemoved = dropRecentBrokersParameters.dropRecentlyRemovedBrokers();
        if (!brokersToDropFromRecentlyRemoved.isEmpty()) {
            Set<Integer> recentlyRemovedBrokers;
            if (!this._kafkaCruiseControl.dropRecentBrokers(brokersToDropFromRecentlyRemoved, true)) {
                recentlyRemovedBrokers = this._kafkaCruiseControl.recentBrokers(true);
                sb.append(String.format("None of the brokers to drop (%s) are in the recently removed broker set (%s).%n", brokersToDropFromRecentlyRemoved, recentlyRemovedBrokers));
                LOG.warn("None of the user-requested brokers to drop ({}) are in the recently removed broker set ({}).", brokersToDropFromRecentlyRemoved, recentlyRemovedBrokers);
            } else {
                recentlyRemovedBrokers = this._kafkaCruiseControl.recentBrokers(true);
                sb.append(String.format("Dropped recently removed brokers (requested: %s after-dropping: %s).%n", brokersToDropFromRecentlyRemoved, recentlyRemovedBrokers));
                LOG.info("Recently removed brokers are dropped by user (requested: {} after-dropping: {}).", brokersToDropFromRecentlyRemoved, recentlyRemovedBrokers);
            }
        }
        if (!(brokersToDropFromRecentlyDemoted = dropRecentBrokersParameters.dropRecentlyDemotedBrokers()).isEmpty()) {
            if (!this._kafkaCruiseControl.dropRecentBrokers(brokersToDropFromRecentlyDemoted, false)) {
                Set<Integer> recentlyDemotedBrokers = this._kafkaCruiseControl.recentBrokers(false);
                sb.append(String.format("None of the brokers to drop (%s) are in the recently demoted broker set (%s).%n", brokersToDropFromRecentlyDemoted, recentlyDemotedBrokers));
                LOG.warn("None of the user-requested brokers to drop ({}) are in the recently demoted broker set ({}).", brokersToDropFromRecentlyDemoted, recentlyDemotedBrokers);
            } else {
                Set<Integer> recentlyDemotedBrokers = this._kafkaCruiseControl.recentBrokers(false);
                sb.append(String.format("Dropped recently demoted brokers (requested: %s after-dropping: %s).%n", brokersToDropFromRecentlyDemoted, recentlyDemotedBrokers));
                LOG.info("Recently demoted brokers are dropped by user (requested: {} after-dropping: {}).", brokersToDropFromRecentlyDemoted, recentlyDemotedBrokers);
            }
        }
        return sb.toString();
    }

    @Override
    public AdminParameters parameters() {
        return this._parameters;
    }

    @Override
    public String name() {
        return AdminRequest.class.getSimpleName();
    }

    @Override
    public void configure(Map<String, ?> configs) {
        super.configure(configs);
        this._kafkaCruiseControl = this._servlet.asyncKafkaCruiseControl();
        this._parameters = (AdminParameters)configs.get("admin.parameter.object");
        if (this._parameters == null) {
            throw new IllegalArgumentException("Parameter configuration is missing from the request.");
        }
    }
}

