/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.servlet.handler.async.runnable;

import com.linkedin.cruisecontrol.exception.NotEnoughValidWindowsException;
import com.linkedin.kafka.cruisecontrol.KafkaCruiseControl;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizationOptions;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizerResult;
import com.linkedin.kafka.cruisecontrol.exception.KafkaCruiseControlException;
import com.linkedin.kafka.cruisecontrol.executor.strategy.ReplicaMovementStrategy;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.model.ReplicaPlacementInfo;
import com.linkedin.kafka.cruisecontrol.servlet.handler.async.runnable.GoalBasedOperationRunnable;
import com.linkedin.kafka.cruisecontrol.servlet.handler.async.runnable.OperationFuture;
import com.linkedin.kafka.cruisecontrol.servlet.handler.async.runnable.RunnableUtils;
import com.linkedin.kafka.cruisecontrol.servlet.parameters.TopicConfigurationParameters;
import com.linkedin.kafka.cruisecontrol.servlet.parameters.TopicReplicationFactorChangeParameters;
import com.linkedin.kafka.cruisecontrol.servlet.response.OptimizationResult;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;

public class UpdateTopicConfigurationRunnable
extends GoalBasedOperationRunnable {
    protected final Map<Short, Pattern> _topicPatternByReplicationFactor;
    protected final boolean _skipRackAwarenessCheck;
    protected final Integer _concurrentInterBrokerPartitionMovements;
    protected final Integer _concurrentLeaderMovements;
    protected final Long _executionProgressCheckIntervalMs;
    protected final ReplicaMovementStrategy _replicaMovementStrategy;
    protected final Long _replicationThrottle;
    protected Cluster _cluster = null;
    protected Map<Short, Set<String>> _topicsToChangeByReplicationFactor;
    protected static final boolean SKIP_AUTO_REFRESHING_CONCURRENCY = true;

    public UpdateTopicConfigurationRunnable(KafkaCruiseControl kafkaCruiseControl, OperationFuture future, String uuid, TopicConfigurationParameters parameters) {
        super(kafkaCruiseControl, future, parameters, parameters.dryRun(), parameters.stopOngoingExecution(), parameters.topicReplicationFactorChangeParameters() != null && parameters.topicReplicationFactorChangeParameters().skipHardGoalCheck(), uuid, parameters::reason, true);
        this._topicsToChangeByReplicationFactor = null;
        TopicReplicationFactorChangeParameters topicReplicationFactorChangeParameters = parameters.topicReplicationFactorChangeParameters();
        if (topicReplicationFactorChangeParameters != null) {
            this._topicPatternByReplicationFactor = topicReplicationFactorChangeParameters.topicPatternByReplicationFactor();
            this._skipRackAwarenessCheck = topicReplicationFactorChangeParameters.skipRackAwarenessCheck();
            this._concurrentInterBrokerPartitionMovements = topicReplicationFactorChangeParameters.concurrentInterBrokerPartitionMovements();
            this._concurrentLeaderMovements = topicReplicationFactorChangeParameters.concurrentLeaderMovements();
            this._executionProgressCheckIntervalMs = topicReplicationFactorChangeParameters.executionProgressCheckIntervalMs();
            this._replicaMovementStrategy = topicReplicationFactorChangeParameters.replicaMovementStrategy();
            this._replicationThrottle = topicReplicationFactorChangeParameters.replicationThrottle();
        } else {
            this._topicPatternByReplicationFactor = null;
            this._skipRackAwarenessCheck = false;
            this._concurrentInterBrokerPartitionMovements = null;
            this._concurrentLeaderMovements = null;
            this._executionProgressCheckIntervalMs = null;
            this._replicaMovementStrategy = null;
            this._replicationThrottle = null;
        }
    }

    public UpdateTopicConfigurationRunnable(KafkaCruiseControl kafkaCruiseControl, Map<Short, Pattern> topicPatternByReplicationFactor, List<String> selfHealingGoals, boolean allowCapacityEstimation, boolean excludeRecentlyDemotedBrokers, boolean excludeRecentlyRemovedBrokers, String anomalyId, Supplier<String> reasonSupplier) {
        super(kafkaCruiseControl, new OperationFuture("Topic replication factor anomaly self-healing."), selfHealingGoals, allowCapacityEstimation, excludeRecentlyDemotedBrokers, excludeRecentlyRemovedBrokers, anomalyId, reasonSupplier, false);
        this._topicPatternByReplicationFactor = topicPatternByReplicationFactor;
        this._skipRackAwarenessCheck = false;
        this._concurrentInterBrokerPartitionMovements = RunnableUtils.SELF_HEALING_CONCURRENT_MOVEMENTS;
        this._concurrentLeaderMovements = RunnableUtils.SELF_HEALING_CONCURRENT_MOVEMENTS;
        this._executionProgressCheckIntervalMs = RunnableUtils.SELF_HEALING_EXECUTION_PROGRESS_CHECK_INTERVAL_MS;
        this._replicaMovementStrategy = RunnableUtils.SELF_HEALING_REPLICA_MOVEMENT_STRATEGY;
        this._replicationThrottle = kafkaCruiseControl.config().getLong("default.replication.throttle");
    }

    @Override
    public OptimizationResult getResult() throws Exception {
        if (this._topicPatternByReplicationFactor != null) {
            return new OptimizationResult(this.computeResult(), this._kafkaCruiseControl.config());
        }
        throw new IllegalArgumentException("Nothing executable found in request.");
    }

    @Override
    protected void init() {
        super.init();
        this._cluster = this._kafkaCruiseControl.kafkaCluster();
        PartitionInfo partitionInfo = RunnableUtils.partitionWithOfflineReplicas(this._cluster);
        if (partitionInfo != null) {
            throw new IllegalStateException(String.format("Topic partition %s-%d has offline replicas on brokers %s.", partitionInfo.topic(), partitionInfo.partition(), Arrays.stream(partitionInfo.offlineReplicas()).mapToInt(Node::id).boxed().collect(Collectors.toSet())));
        }
        this._topicsToChangeByReplicationFactor = RunnableUtils.topicsForReplicationFactorChange(this._topicPatternByReplicationFactor, this._cluster);
    }

    @Override
    protected OptimizerResult workWithClusterModel() throws KafkaCruiseControlException, TimeoutException, NotEnoughValidWindowsException {
        HashMap<String, List<Integer>> brokersByRack = new HashMap<String, List<Integer>>();
        HashMap<Integer, String> rackByBroker = new HashMap<Integer, String>();
        ClusterModel clusterModel = this._kafkaCruiseControl.clusterModel(this._combinedCompletenessRequirements, this._allowCapacityEstimation, this._operationProgress);
        if (!clusterModel.isClusterAlive()) {
            throw new IllegalArgumentException("All brokers are dead in the cluster.");
        }
        OptimizationOptions optimizationOptions = RunnableUtils.computeOptimizationOptions(clusterModel, false, this._kafkaCruiseControl, Collections.emptySet(), this._dryRun, this._excludeRecentlyDemotedBrokers, this._excludeRecentlyRemovedBrokers, this._excludedTopics, Collections.emptySet(), true);
        RunnableUtils.populateRackInfoForReplicationFactorChange(this._topicsToChangeByReplicationFactor, this._cluster, this._skipRackAwarenessCheck, brokersByRack, rackByBroker);
        Map<TopicPartition, List<ReplicaPlacementInfo>> initReplicaDistribution = clusterModel.getReplicaDistribution();
        clusterModel.createOrDeleteReplicas(this._topicsToChangeByReplicationFactor, brokersByRack, rackByBroker, this._cluster);
        OptimizerResult result = this._kafkaCruiseControl.optimizations(clusterModel, this._goalsByPriority, this._operationProgress, initReplicaDistribution, optimizationOptions);
        if (!this._dryRun) {
            this._kafkaCruiseControl.executeProposals(result.goalProposals(), Collections.emptySet(), false, this._concurrentInterBrokerPartitionMovements, 0, this._concurrentLeaderMovements, this._executionProgressCheckIntervalMs, this._replicaMovementStrategy, this._replicationThrottle, this._isTriggeredByUserRequest, this._uuid, true);
        }
        return result;
    }

    @Override
    protected boolean shouldWorkWithClusterModel() {
        return true;
    }

    @Override
    protected OptimizerResult workWithoutClusterModel() {
        return null;
    }

    @Override
    protected void finish() {
        super.finish();
        this._cluster = null;
        this._topicsToChangeByReplicationFactor.clear();
    }
}

