/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.servlet.handler.async.runnable;

import com.linkedin.cruisecontrol.exception.NotEnoughValidWindowsException;
import com.linkedin.kafka.cruisecontrol.KafkaCruiseControl;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizationOptions;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizerResult;
import com.linkedin.kafka.cruisecontrol.exception.KafkaCruiseControlException;
import com.linkedin.kafka.cruisecontrol.executor.strategy.ReplicaMovementStrategy;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.servlet.handler.async.runnable.GoalBasedOperationRunnable;
import com.linkedin.kafka.cruisecontrol.servlet.handler.async.runnable.OperationFuture;
import com.linkedin.kafka.cruisecontrol.servlet.handler.async.runnable.RunnableUtils;
import com.linkedin.kafka.cruisecontrol.servlet.parameters.RemoveBrokerParameters;
import com.linkedin.kafka.cruisecontrol.servlet.response.OptimizationResult;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;

public class RemoveBrokersRunnable
extends GoalBasedOperationRunnable {
    protected final Set<Integer> _removedBrokerIds;
    protected final Set<Integer> _destinationBrokerIds;
    protected final boolean _throttleRemovedBrokers;
    protected final Integer _concurrentInterBrokerPartitionMovements;
    protected final Integer _concurrentLeaderMovements;
    protected final Long _executionProgressCheckIntervalMs;
    protected final ReplicaMovementStrategy _replicaMovementStrategy;
    protected final Long _replicationThrottle;

    public RemoveBrokersRunnable(KafkaCruiseControl kafkaCruiseControl, Set<Integer> removedBrokerIds, List<String> selfHealingGoals, boolean allowCapacityEstimation, boolean excludeRecentlyDemotedBrokers, boolean excludeRecentlyRemovedBrokers, String anomalyId, Supplier<String> reasonSupplier) {
        super(kafkaCruiseControl, new OperationFuture("Broker Failure Self-Healing"), selfHealingGoals, allowCapacityEstimation, excludeRecentlyDemotedBrokers, excludeRecentlyRemovedBrokers, anomalyId, reasonSupplier, false);
        this._removedBrokerIds = removedBrokerIds;
        this._throttleRemovedBrokers = false;
        this._destinationBrokerIds = RunnableUtils.SELF_HEALING_DESTINATION_BROKER_IDS;
        this._concurrentInterBrokerPartitionMovements = RunnableUtils.SELF_HEALING_CONCURRENT_MOVEMENTS;
        this._concurrentLeaderMovements = RunnableUtils.SELF_HEALING_CONCURRENT_MOVEMENTS;
        this._executionProgressCheckIntervalMs = RunnableUtils.SELF_HEALING_EXECUTION_PROGRESS_CHECK_INTERVAL_MS;
        this._replicaMovementStrategy = RunnableUtils.SELF_HEALING_REPLICA_MOVEMENT_STRATEGY;
        this._replicationThrottle = kafkaCruiseControl.config().getLong("default.replication.throttle");
    }

    public RemoveBrokersRunnable(KafkaCruiseControl kafkaCruiseControl, OperationFuture future, RemoveBrokerParameters parameters, String uuid) {
        super(kafkaCruiseControl, future, parameters, parameters.dryRun(), parameters.stopOngoingExecution(), parameters.skipHardGoalCheck(), uuid, parameters::reason, true);
        this._removedBrokerIds = parameters.brokerIds();
        this._throttleRemovedBrokers = parameters.throttleRemovedBrokers();
        this._destinationBrokerIds = parameters.destinationBrokerIds();
        this._concurrentInterBrokerPartitionMovements = parameters.concurrentInterBrokerPartitionMovements();
        this._concurrentLeaderMovements = parameters.concurrentLeaderMovements();
        this._executionProgressCheckIntervalMs = parameters.executionProgressCheckIntervalMs();
        this._replicaMovementStrategy = parameters.replicaMovementStrategy();
        this._replicationThrottle = parameters.replicationThrottle();
    }

    @Override
    protected OptimizationResult getResult() throws Exception {
        return new OptimizationResult(this.computeResult(), this._kafkaCruiseControl.config());
    }

    @Override
    protected OptimizerResult workWithClusterModel() throws KafkaCruiseControlException, TimeoutException, NotEnoughValidWindowsException {
        ClusterModel clusterModel = this._kafkaCruiseControl.clusterModel(this._combinedCompletenessRequirements, this._allowCapacityEstimation, this._operationProgress);
        RunnableUtils.sanityCheckBrokersHavingOfflineReplicasOnBadDisks(this._goals, clusterModel);
        this._removedBrokerIds.forEach(id -> clusterModel.setBrokerState((int)id, Broker.State.DEAD));
        if (!clusterModel.isClusterAlive()) {
            throw new IllegalArgumentException("All brokers are dead in the cluster.");
        }
        if (!this._destinationBrokerIds.isEmpty()) {
            this._kafkaCruiseControl.sanityCheckBrokerPresence(this._destinationBrokerIds);
        }
        OptimizationOptions optimizationOptions = RunnableUtils.computeOptimizationOptions(clusterModel, false, this._kafkaCruiseControl, this._destinationBrokerIds, this._dryRun, this._excludeRecentlyDemotedBrokers, this._excludeRecentlyRemovedBrokers, this._excludedTopics, this._destinationBrokerIds, false);
        OptimizerResult result = this._kafkaCruiseControl.optimizations(clusterModel, this._goalsByPriority, this._operationProgress, null, optimizationOptions);
        if (!this._dryRun) {
            this._kafkaCruiseControl.executeRemoval(result.goalProposals(), this._throttleRemovedBrokers, this._removedBrokerIds, RunnableUtils.isKafkaAssignerMode(this._goals), this._concurrentInterBrokerPartitionMovements, this._concurrentLeaderMovements, this._executionProgressCheckIntervalMs, this._replicaMovementStrategy, this._replicationThrottle, this._isTriggeredByUserRequest, this._uuid);
        }
        return result;
    }

    @Override
    protected boolean shouldWorkWithClusterModel() {
        return true;
    }

    @Override
    protected OptimizerResult workWithoutClusterModel() {
        return null;
    }
}

