/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.servlet.handler.async.runnable;

import com.linkedin.kafka.cruisecontrol.KafkaCruiseControl;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizerResult;
import com.linkedin.kafka.cruisecontrol.exception.KafkaCruiseControlException;
import com.linkedin.kafka.cruisecontrol.executor.strategy.ReplicaMovementStrategy;
import com.linkedin.kafka.cruisecontrol.servlet.handler.async.runnable.GoalBasedOperationRunnable;
import com.linkedin.kafka.cruisecontrol.servlet.handler.async.runnable.OperationFuture;
import com.linkedin.kafka.cruisecontrol.servlet.handler.async.runnable.ProposalsRunnable;
import com.linkedin.kafka.cruisecontrol.servlet.handler.async.runnable.RunnableUtils;
import com.linkedin.kafka.cruisecontrol.servlet.parameters.RebalanceParameters;
import com.linkedin.kafka.cruisecontrol.servlet.response.OptimizationResult;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;

public class RebalanceRunnable
extends GoalBasedOperationRunnable {
    public static final boolean SELF_HEALING_IGNORE_PROPOSAL_CACHE = false;
    public static final boolean SELF_HEALING_IS_REBALANCE_DISK_MODE = false;
    protected final Integer _concurrentInterBrokerPartitionMovements;
    protected final Integer _concurrentIntraBrokerPartitionMovements;
    protected final Integer _concurrentLeaderMovements;
    protected final Long _executionProgressCheckIntervalMs;
    protected final ReplicaMovementStrategy _replicaMovementStrategy;
    protected final Long _replicationThrottle;
    protected final boolean _ignoreProposalCache;
    protected final Set<Integer> _destinationBrokerIds;
    protected final boolean _isRebalanceDiskMode;
    protected static final boolean SKIP_AUTO_REFRESHING_CONCURRENCY = false;

    public RebalanceRunnable(KafkaCruiseControl kafkaCruiseControl, List<String> selfHealingGoals, boolean allowCapacityEstimation, boolean excludeRecentlyDemotedBrokers, boolean excludeRecentlyRemovedBrokers, String anomalyId, Supplier<String> reasonSupplier) {
        super(kafkaCruiseControl, new OperationFuture("Goal Violation Self-Healing"), selfHealingGoals, allowCapacityEstimation, excludeRecentlyDemotedBrokers, excludeRecentlyRemovedBrokers, anomalyId, reasonSupplier, false);
        this._concurrentInterBrokerPartitionMovements = RunnableUtils.SELF_HEALING_CONCURRENT_MOVEMENTS;
        this._concurrentIntraBrokerPartitionMovements = RunnableUtils.SELF_HEALING_CONCURRENT_MOVEMENTS;
        this._concurrentLeaderMovements = RunnableUtils.SELF_HEALING_CONCURRENT_MOVEMENTS;
        this._executionProgressCheckIntervalMs = RunnableUtils.SELF_HEALING_EXECUTION_PROGRESS_CHECK_INTERVAL_MS;
        this._replicaMovementStrategy = RunnableUtils.SELF_HEALING_REPLICA_MOVEMENT_STRATEGY;
        this._replicationThrottle = kafkaCruiseControl.config().getLong("default.replication.throttle");
        this._ignoreProposalCache = false;
        this._destinationBrokerIds = RunnableUtils.SELF_HEALING_DESTINATION_BROKER_IDS;
        this._isRebalanceDiskMode = false;
    }

    public RebalanceRunnable(KafkaCruiseControl kafkaCruiseControl, OperationFuture future, RebalanceParameters parameters, String uuid) {
        super(kafkaCruiseControl, future, parameters, parameters.dryRun(), parameters.stopOngoingExecution(), parameters.skipHardGoalCheck(), uuid, parameters::reason, true);
        this._concurrentInterBrokerPartitionMovements = parameters.concurrentInterBrokerPartitionMovements();
        this._concurrentIntraBrokerPartitionMovements = parameters.concurrentIntraBrokerPartitionMovements();
        this._concurrentLeaderMovements = parameters.concurrentLeaderMovements();
        this._executionProgressCheckIntervalMs = parameters.executionProgressCheckIntervalMs();
        this._replicaMovementStrategy = parameters.replicaMovementStrategy();
        this._replicationThrottle = parameters.replicationThrottle();
        this._ignoreProposalCache = parameters.ignoreProposalCache();
        this._destinationBrokerIds = parameters.destinationBrokerIds();
        this._isRebalanceDiskMode = parameters.isRebalanceDiskMode();
    }

    @Override
    protected OptimizationResult getResult() throws Exception {
        return new OptimizationResult(this.computeResult(), this._kafkaCruiseControl.config());
    }

    @Override
    protected void init() {
        this._kafkaCruiseControl.sanityCheckDryRun(this._dryRun, this._stopOngoingExecution);
        if (this._stopOngoingExecution) {
            RunnableUtils.maybeStopOngoingExecutionToModifyAndWait(this._kafkaCruiseControl, this._future.operationProgress());
        }
    }

    @Override
    protected boolean shouldWorkWithClusterModel() {
        return false;
    }

    @Override
    protected OptimizerResult workWithClusterModel() {
        return null;
    }

    @Override
    protected OptimizerResult workWithoutClusterModel() throws KafkaCruiseControlException {
        ProposalsRunnable proposalsRunnable = new ProposalsRunnable(this._kafkaCruiseControl, this._future, this._goals, this._modelCompletenessRequirements, this._allowCapacityEstimation, this._excludedTopics, this._excludeRecentlyDemotedBrokers, this._excludeRecentlyRemovedBrokers, this._ignoreProposalCache, this._destinationBrokerIds, this._isRebalanceDiskMode, this._skipHardGoalCheck, !this._isTriggeredByUserRequest);
        OptimizerResult result = proposalsRunnable.computeResult();
        if (!this._dryRun) {
            this._kafkaCruiseControl.executeProposals(result.goalProposals(), Collections.emptySet(), RunnableUtils.isKafkaAssignerMode(this._goals), this._concurrentInterBrokerPartitionMovements, this._concurrentIntraBrokerPartitionMovements, this._concurrentLeaderMovements, this._executionProgressCheckIntervalMs, this._replicaMovementStrategy, this._replicationThrottle, this._isTriggeredByUserRequest, this._uuid, false);
        }
        return result;
    }
}

