/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.servlet.handler.async.runnable;

import com.linkedin.cruisecontrol.exception.NotEnoughValidWindowsException;
import com.linkedin.kafka.cruisecontrol.KafkaCruiseControl;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizationOptions;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizerResult;
import com.linkedin.kafka.cruisecontrol.exception.KafkaCruiseControlException;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.monitor.ModelCompletenessRequirements;
import com.linkedin.kafka.cruisecontrol.servlet.handler.async.runnable.GoalBasedOperationRunnable;
import com.linkedin.kafka.cruisecontrol.servlet.handler.async.runnable.OperationFuture;
import com.linkedin.kafka.cruisecontrol.servlet.handler.async.runnable.RunnableUtils;
import com.linkedin.kafka.cruisecontrol.servlet.parameters.ProposalsParameters;
import com.linkedin.kafka.cruisecontrol.servlet.response.OptimizationResult;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import java.util.regex.Pattern;

public class ProposalsRunnable
extends GoalBasedOperationRunnable {
    protected final boolean _ignoreProposalCache;
    protected final Set<Integer> _destinationBrokerIds;
    protected final boolean _isRebalanceDiskMode;
    protected final boolean _isTriggeredByGoalViolation;
    protected static final boolean PROPOSALS_DRYRUN = true;
    protected static final boolean PROPOSALS_STOP_ONGOING_EXECUTION = false;
    protected static final boolean PROPOSALS_SKIP_HARD_GOAL_CHECK = true;
    protected static final boolean PROPOSALS_IS_TRIGGERED_BY_GOAL_VIOLATION = false;
    protected static final String PROPOSALS_UUID = null;
    protected static final Supplier<String> PROPOSALS_REASON_SUPPLIER = null;
    protected static final boolean PROPOSALS_IS_TRIGGERED_BY_USER_REQUEST = true;

    public ProposalsRunnable(KafkaCruiseControl kafkaCruiseControl, OperationFuture future, List<String> goals, ModelCompletenessRequirements modelCompletenessRequirements, boolean allowCapacityEstimation, Pattern excludedTopics, boolean excludeRecentlyDemotedBrokers, boolean excludeRecentlyRemovedBrokers, boolean ignoreProposalCache, Set<Integer> destinationBrokerIds, boolean isRebalanceDiskMode, boolean skipHardGoalCheck, boolean isTriggeredByGoalViolation) {
        super(kafkaCruiseControl, future, true, goals, false, modelCompletenessRequirements, skipHardGoalCheck, excludedTopics, allowCapacityEstimation, excludeRecentlyDemotedBrokers, excludeRecentlyRemovedBrokers, PROPOSALS_UUID, PROPOSALS_REASON_SUPPLIER, true);
        this._ignoreProposalCache = ignoreProposalCache;
        this._destinationBrokerIds = destinationBrokerIds;
        this._isRebalanceDiskMode = isRebalanceDiskMode;
        this._isTriggeredByGoalViolation = isTriggeredByGoalViolation;
    }

    public ProposalsRunnable(KafkaCruiseControl kafkaCruiseControl, OperationFuture future, ProposalsParameters parameters) {
        super(kafkaCruiseControl, future, parameters, true, false, true, PROPOSALS_UUID, PROPOSALS_REASON_SUPPLIER, true);
        this._ignoreProposalCache = parameters.ignoreProposalCache();
        this._destinationBrokerIds = parameters.destinationBrokerIds();
        this._isRebalanceDiskMode = parameters.isRebalanceDiskMode();
        this._isTriggeredByGoalViolation = false;
    }

    @Override
    protected OptimizationResult getResult() throws Exception {
        return new OptimizationResult(this.computeResult(), this._kafkaCruiseControl.config());
    }

    @Override
    protected OptimizerResult workWithClusterModel() throws KafkaCruiseControlException, TimeoutException, NotEnoughValidWindowsException {
        ClusterModel clusterModel = this._kafkaCruiseControl.clusterModel(-1L, this._kafkaCruiseControl.timeMs(), this._combinedCompletenessRequirements, this._isRebalanceDiskMode, this._allowCapacityEstimation, this._operationProgress);
        RunnableUtils.sanityCheckBrokersHavingOfflineReplicasOnBadDisks(this._goals, clusterModel);
        if (!clusterModel.isClusterAlive()) {
            throw new IllegalArgumentException("All brokers are dead in the cluster.");
        }
        if (!this._destinationBrokerIds.isEmpty()) {
            this._kafkaCruiseControl.sanityCheckBrokerPresence(this._destinationBrokerIds);
        }
        OptimizationOptions optimizationOptions = RunnableUtils.computeOptimizationOptions(clusterModel, this._isTriggeredByGoalViolation, this._kafkaCruiseControl, this._destinationBrokerIds, this._dryRun, this._excludeRecentlyDemotedBrokers, this._excludeRecentlyRemovedBrokers, this._excludedTopics, this._destinationBrokerIds, false);
        return this._kafkaCruiseControl.optimizations(clusterModel, this._goalsByPriority, this._operationProgress, null, optimizationOptions);
    }

    @Override
    protected OptimizerResult workWithoutClusterModel() throws KafkaCruiseControlException {
        return this._kafkaCruiseControl.getProposals(this._operationProgress, this._allowCapacityEstimation);
    }

    @Override
    protected boolean shouldWorkWithClusterModel() {
        return this._kafkaCruiseControl.ignoreProposalCache(this._goals, this._combinedCompletenessRequirements, this._excludedTopics, this._excludeRecentlyDemotedBrokers || this._excludeRecentlyRemovedBrokers, this._ignoreProposalCache, this._isTriggeredByGoalViolation, this._destinationBrokerIds, this._isRebalanceDiskMode);
    }
}

