/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.servlet.handler.async.runnable;

import com.linkedin.kafka.cruisecontrol.KafkaCruiseControl;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.model.Partition;
import com.linkedin.kafka.cruisecontrol.servlet.handler.async.runnable.LoadRunnable;
import com.linkedin.kafka.cruisecontrol.servlet.handler.async.runnable.OperationFuture;
import com.linkedin.kafka.cruisecontrol.servlet.handler.async.runnable.OperationRunnable;
import com.linkedin.kafka.cruisecontrol.servlet.parameters.PartitionLoadParameters;
import com.linkedin.kafka.cruisecontrol.servlet.response.PartitionLoadState;
import java.util.List;
import java.util.stream.Collectors;

public class PartitionLoadRunnable
extends OperationRunnable {
    protected final PartitionLoadParameters _parameters;

    public PartitionLoadRunnable(KafkaCruiseControl kafkaCruiseControl, OperationFuture future, PartitionLoadParameters parameters) {
        super(kafkaCruiseControl, future);
        this._parameters = parameters;
    }

    @Override
    protected PartitionLoadState getResult() throws Exception {
        this._kafkaCruiseControl.sanityCheckBrokerPresence(this._parameters.brokerIds());
        LoadRunnable loadRunnable = new LoadRunnable(this._kafkaCruiseControl, this._future, this._parameters);
        Double minValidPartitionRatio = this._parameters.minValidPartitionRatio();
        if (minValidPartitionRatio == null) {
            minValidPartitionRatio = this._kafkaCruiseControl.config().getDouble("min.valid.partition.ratio");
        }
        ClusterModel clusterModel = loadRunnable.clusterModel(minValidPartitionRatio);
        int topicNameLength = clusterModel.topics().stream().mapToInt(String::length).max().orElse(20) + 5;
        List<Partition> partitionList = clusterModel.replicasSortedByUtilization(this._parameters.resource(), this._parameters.wantMaxLoad(), this._parameters.wantAvgLoad());
        if (!this._parameters.brokerIds().isEmpty()) {
            partitionList = partitionList.stream().filter(partition -> partition.partitionBrokers().stream().anyMatch(broker -> this._parameters.brokerIds().contains(broker.id()))).collect(Collectors.toList());
        }
        return new PartitionLoadState(partitionList, this._parameters.wantMaxLoad(), this._parameters.wantAvgLoad(), this._parameters.entries(), this._parameters.partitionUpperBoundary(), this._parameters.partitionLowerBoundary(), this._parameters.topic(), topicNameLength, this._kafkaCruiseControl.config());
    }
}

