/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.servlet.handler.async.runnable;

import com.linkedin.cruisecontrol.servlet.response.CruiseControlResponse;
import com.linkedin.kafka.cruisecontrol.KafkaCruiseControl;
import com.linkedin.kafka.cruisecontrol.async.progress.OperationStep;
import com.linkedin.kafka.cruisecontrol.async.progress.Pending;
import com.linkedin.kafka.cruisecontrol.servlet.handler.async.runnable.OperationFuture;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class OperationRunnable
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(OperationRunnable.class);
    protected final KafkaCruiseControl _kafkaCruiseControl;
    protected final OperationFuture _future;

    OperationRunnable(KafkaCruiseControl kafkaCruiseControl, OperationFuture future) {
        this._kafkaCruiseControl = kafkaCruiseControl;
        this._future = future;
    }

    protected OperationFuture future() {
        return this._future;
    }

    @Override
    public void run() {
        try {
            if (this._future.setExecutionThread(Thread.currentThread())) {
                List<OperationStep> steps = this._future.operationProgress().progress();
                if (!steps.isEmpty() && steps.get(0) instanceof Pending) {
                    ((Pending)steps.get(0)).done();
                }
                this._future.complete(this.getResult());
                this._future.setFinishTimeNs(System.nanoTime());
            }
        }
        catch (Exception e) {
            LOG.warn("Received exception when trying to execute runnable for \"" + this._future.operation() + "\"", (Throwable)e);
            this._future.completeExceptionally(e);
        }
        finally {
            this._future.setExecutionThread(null);
            Thread.interrupted();
        }
    }

    protected abstract CruiseControlResponse getResult() throws Exception;
}

