/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.servlet.handler.async.runnable;

import com.linkedin.cruisecontrol.servlet.response.CruiseControlResponse;
import com.linkedin.kafka.cruisecontrol.async.progress.OperationProgress;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

public class OperationFuture
extends CompletableFuture<CruiseControlResponse> {
    protected final String _operation;
    protected final OperationProgress _operationProgress;
    protected volatile Thread _executionThread = null;
    protected long _finishTimeNs;

    public OperationFuture(String operation) {
        this._operation = operation;
        this._operationProgress = new OperationProgress(operation);
        this._finishTimeNs = -1L;
    }

    @Override
    public synchronized boolean cancel(boolean mayInterruptIfRunning) {
        boolean canceled = false;
        if (this._executionThread != null) {
            if (mayInterruptIfRunning) {
                canceled = super.cancel(true);
                this._executionThread.interrupt();
            }
        } else {
            canceled = super.cancel(true);
        }
        this.notifyAll();
        return canceled;
    }

    @Override
    public CruiseControlResponse get() throws InterruptedException, ExecutionException {
        try {
            return (CruiseControlResponse)super.get();
        }
        catch (Throwable t) {
            try {
                Field f = Throwable.class.getDeclaredField("detailMessage");
                f.setAccessible(true);
                f.set(t, String.format("Operation '%s' received exception. ", this._operation) + (t.getMessage() == null ? "" : t.getMessage()));
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                // empty catch block
            }
            throw t;
        }
    }

    public String operation() {
        return this._operation;
    }

    public synchronized boolean setExecutionThread(Thread t) {
        if (this.isCancelled() && t != null) {
            return false;
        }
        this._executionThread = t;
        return true;
    }

    public String progressString() {
        return this._operationProgress.toString();
    }

    public Map<String, Object> getJsonStructure() {
        return this._operationProgress.getJsonStructure();
    }

    public OperationProgress operationProgress() {
        return this._operationProgress;
    }

    public void setFinishTimeNs(long finishTimeNs) {
        this._finishTimeNs = finishTimeNs;
    }

    public long finishTimeNs() {
        return this._finishTimeNs;
    }
}

